/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.context;

import java.awt.EventQueue;
import org.apache.log4j.Logger;
import ru.softlogic.app.LoggerId;
import ru.softlogic.app.context.ApplicationContext;
import ru.softlogic.app.session.Session;
import ru.softlogic.cash.Keeper;
import ru.softlogic.gui.useraction.UserAction;
import ru.softlogic.intent.ExitIntent;
import ru.softlogic.module.Module;
import ru.softlogic.module.ModuleMessage;
import ru.softlogic.module.ModuleStore;

public class ReturnService
implements Runnable {
    private final Logger log = LoggerId.GUI;
    private final ApplicationContext context;
    private final ModuleStore store;

    public ReturnService(ApplicationContext context, ModuleStore store) {
        this.context = context;
        this.store = store;
    }

    @Override
    public void run() {
        int timeout;
        Module module = this.store.getModule();
        if (module != null && (timeout = module.getInactivityTimeout()) > 0 && UserAction.getInstance().isElapsed(timeout)) {
            EventQueue.invokeLater(new LocalReturnRunner(module, timeout));
        }
    }

    private class LocalReturnRunner
    implements Runnable {
        private final Module module;
        private final int timeout;

        public LocalReturnRunner(Module module, int timeout) {
            this.module = module;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            Keeper kp = Session.getInstance().getCurrentKeeper();
            if (UserAction.getInstance().isElapsed(this.timeout)) {
                ReturnService.this.log.info((Object)("Inactivity timeout was detected: " + ModuleMessage.getModuleType(this.module.getType())));
                if (this.module.getType() != 1 || kp == null || kp.getSum().isEmpty()) {
                    UserAction.getInstance().update();
                }
                this.module.cancel(new ExitIntent(ReturnService.this.context));
            }
        }
    }
}

