/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.context;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.Logger;
import ru.softlogic.reference.ReferenceManager;
import ru.softlogic.reference.point.Point;

public class ChequeGenerator {
    private static volatile ChequeGenerator instance;
    private static List<String> oldChequeNumbers;
    private static final Random rand;
    private final Logger log = Logger.getLogger(ChequeGenerator.class);

    private ChequeGenerator() {
    }

    public String getChequeNumber() {
        String chequeNumber;
        int id;
        Calendar cal = Calendar.getInstance();
        int hourOfDay = cal.get(11);
        int hourOfYear = cal.get(6) * 24 + hourOfDay;
        String prefix = FastDateFormat.getInstance((String)("yy" + String.format("%04d", hourOfYear) + "mm")).format(cal);
        try {
            Point point = ReferenceManager.getInstance().getPoint();
            id = point.getId() % 10000;
        }
        catch (Throwable ex) {
            this.log.error((Object)"\u041d\u0435 \u043c\u043e\u0433\u0443 \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c PointId, \u0443\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u043c \u043f\u0440\u0435\u0444\u0438\u043a\u0441 \u0447\u0435\u043a\u0430 9999", ex);
            id = 9999;
        }
        String chequePrefix = String.format("%04d", id) + prefix;
        if (!oldChequeNumbers.isEmpty() && !oldChequeNumbers.get(oldChequeNumbers.size() - 1).regionMatches(0, chequePrefix, 0, 12)) {
            oldChequeNumbers.clear();
        }
        while (oldChequeNumbers.contains(chequeNumber = chequePrefix + String.format("%04d", rand.nextInt(10000)))) {
        }
        oldChequeNumbers.add(chequeNumber);
        return chequeNumber;
    }

    public static ChequeGenerator getInstance() {
        if (instance == null) {
            instance = new ChequeGenerator();
        }
        return instance;
    }

    static {
        oldChequeNumbers = new ArrayList<String>();
        rand = new Random();
    }
}

