/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.configuration;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;
import ru.softlogic.app.configuration.SerialNumbersStore;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.PathUtils;

public class ConfigurationSN {
    private static ConfigurationSN instance = new ConfigurationSN();
    private SerialNumbersStore store;
    private String path;

    private ConfigurationSN() {
        String baseDir = "";
        try {
            baseDir = FileUtil.checkDir((String)PathUtils.getAppHome()).getAbsolutePath();
        }
        catch (FileUtilException fileUtilException) {
            // empty catch block
        }
        this.path = baseDir + "/serialnumbers.store";
        this.readStore();
    }

    public static ConfigurationSN getInstance() {
        return instance;
    }

    public SerialNumbersStore getStore() {
        return this.store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readStore() {
        ObjectInputStream ois = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(this.path);
            ois = new ObjectInputStream(fis);
            Object obj = ois.readObject();
            if (obj instanceof SerialNumbersStore) {
                this.store = (SerialNumbersStore)obj;
            }
        }
        catch (FileNotFoundException fnfex) {
            Logger.getLogger((String)"start").error((Object)("File not found: " + this.path));
        }
        catch (Exception ex) {
            Logger.getLogger((String)"start").error((Object)ex, (Throwable)ex);
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException fnfex) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException fnfex) {}
            }
            if (this.store == null) {
                this.store = new SerialNumbersStore();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStore() throws IOException {
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(this.path);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(this.store);
            oos.flush();
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

