/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app.configuration;

import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import ru.softlogic.app.configuration.AppDefaults;
import ru.softlogic.app.configuration.CardReaderConfiguration;
import ru.softlogic.app.configuration.CdmConfiguration;
import ru.softlogic.app.configuration.ConfigurationException;
import ru.softlogic.app.configuration.DeviceConfiguration;
import ru.softlogic.app.configuration.PresentConfiguration;
import ru.softlogic.gui.GuiOptions;
import ru.softlogic.gui.Rendering;
import ru.softlogic.hardware.device.DeviceClass;
import ru.softlogic.hardware.device.DeviceType;
import ru.softlogic.hardware.device.present.DispenserNetworkOptions;
import ru.softlogic.hardware.device.present.DispenserOptions;
import ru.softlogic.hardware.device.print.ipp.IppPrinterOptions;
import ru.softlogic.hardware.device.print.kkm.KkmOptions;
import ru.softlogic.hardware.device.print.posprinter.PosPrinterOptions;
import ru.softlogic.hardware.device.scanner.BarcodeScannerType;
import ru.softlogic.hardware.device.watchdog.EventListener;
import ru.softlogic.hardware.device.watchdog.WatchDogDescriptor;
import ru.softlogic.hardware.device.watchdog.WatchDogFactory;
import ru.softlogic.hardware.device.watchdog.WatchDogSettings;
import ru.softlogic.io.Port;
import ru.softlogic.io.PortScanner;
import ru.softlogic.io.PortType;
import ru.softlogic.io.parallel.ParallelPort;
import ru.softlogic.io.serial.DataBits;
import ru.softlogic.io.serial.Parity;
import ru.softlogic.io.serial.SerialParams;
import ru.softlogic.io.serial.SerialPort;
import ru.softlogic.io.serial.StopBits;
import ru.softlogic.io.usb.UsbPort;
import ru.softlogic.srv.connector.ConnectorConfiguration;
import ru.softlogic.srv.connector.ConnectorType;
import ru.softlogic.system.util.FileUtil;
import ru.softlogic.system.util.FileUtilException;
import ru.softlogic.system.util.PathUtils;

public class Configuration {
    private static Configuration instance;
    private Logger log = Logger.getLogger((String)"start");
    private File baseDir;
    private DeviceConfiguration<SerialPort> cashAcceptorConfiguration;
    private DeviceConfiguration<SerialPort> coinAcceptorConfiguration;
    private DeviceConfiguration<SerialPort> coinHopperConfiguration;
    private CardReaderConfiguration<Port> cardReaderConfiguration;
    private DeviceConfiguration<SerialPort> pinpadConfiguration;
    private DeviceConfiguration<SerialPort> readerConfiguration;
    private DeviceConfiguration<SerialPort> cvdConfiguration;
    private DeviceClass printerClass;
    private String printHandler;
    private boolean usePaperNearEndSensor = true;
    private DeviceConfiguration<Port> posPrinterConfiguration;
    private DeviceConfiguration<SerialPort> fiscalPrinterConfiguration;
    private boolean fiscalPrinterMode;
    private PosPrinterOptions posPrinterOptions;
    private KkmOptions kkmOptions;
    private String ippPrinterName;
    private IppPrinterOptions ippPrinterOptions;
    private DeviceConfiguration<SerialPort> watchDogConfiguration;
    private DeviceConfiguration<SerialPort> modemConfiguration;
    private boolean ussdCheck;
    private boolean softwareWatchDogUse;
    private boolean ussdAutoRequest;
    private String ussdRequest;
    private boolean pppUse;
    private String pppName;
    private BarcodeScannerType barcodeScannerType;
    private DeviceConfiguration<SerialPort> barcodeScannerConfiguration;
    private Boolean onTop;
    private Boolean showCursor;
    private String screenSize;
    private Rendering rendering;
    private boolean useProxy;
    private String proxyHost;
    private String proxyPort;
    private boolean authProxy;
    private String proxyUser;
    private String proxyPassword;
    private WatchDogSettings watchDogSettings;
    private ConnectorConfiguration defaultConnectorConfiguration;
    private Set<ConnectorConfiguration> connectorConfigurations;
    private String cardModuleType;
    private PresentConfiguration presentConfiguration;
    private CdmConfiguration cdmConfiguration;
    private DeviceType proximityType;
    private String mppkPath;

    private Configuration() {
        this.log.setAdditivity(false);
        this.pppUse = true;
        try {
            this.readConfiguration();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static synchronized Configuration getInstance() {
        if (instance == null) {
            instance = new Configuration();
        }
        return instance;
    }

    public String getApplicationDir() {
        return this.baseDir.getAbsolutePath();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public boolean isUsePaperNearEndSensor() {
        return this.usePaperNearEndSensor;
    }

    public void setUsePaperNearEndSensor(boolean usePaperNearEndSensor) {
        this.usePaperNearEndSensor = usePaperNearEndSensor;
    }

    public void setCashAcceptorConfiguration(DeviceConfiguration<SerialPort> cashAcceptorConfiguration) {
        this.cashAcceptorConfiguration = cashAcceptorConfiguration;
    }

    public DeviceConfiguration<SerialPort> getCashAcceptorConfiguration() {
        return this.cashAcceptorConfiguration;
    }

    public CardReaderConfiguration<Port> getCardReaderConfiguration() {
        return this.cardReaderConfiguration;
    }

    public void setCardReaderConfiguration(CardReaderConfiguration<Port> cardReaderConfiguration) {
        this.cardReaderConfiguration = cardReaderConfiguration;
    }

    public DeviceConfiguration<SerialPort> getCoinAcceptorConfiguration() {
        return this.coinAcceptorConfiguration;
    }

    public DeviceConfiguration<SerialPort> getCvdConfiguration() {
        return this.cvdConfiguration;
    }

    public void setCvdConfiguration(DeviceConfiguration<SerialPort> cvdConfiguration) {
        this.cvdConfiguration = cvdConfiguration;
    }

    public void setCoinAcceptorConfiguration(DeviceConfiguration<SerialPort> coinAcceptorConfiguration) {
        this.coinAcceptorConfiguration = coinAcceptorConfiguration;
    }

    public void setPosPrinterConfiguration(DeviceConfiguration<Port> posPrinterConfiguration) {
        this.posPrinterConfiguration = posPrinterConfiguration;
    }

    public void setFiscalPrinterConfiguration(DeviceConfiguration<SerialPort> fiscalPrinterConfiguration) {
        this.fiscalPrinterConfiguration = fiscalPrinterConfiguration;
    }

    public DeviceConfiguration<SerialPort> getFiscalPrinterConfiguration() {
        return this.fiscalPrinterConfiguration;
    }

    public DeviceConfiguration<Port> getPosPrinterConfiguration() {
        return this.posPrinterConfiguration;
    }

    public void setPosPrinterOptions(PosPrinterOptions posPrinterOptions) {
        this.posPrinterOptions = posPrinterOptions;
    }

    public PosPrinterOptions getPosPrinterOptions() {
        return this.posPrinterOptions;
    }

    public IppPrinterOptions getIppPrinterOptions() {
        if (this.ippPrinterOptions == null) {
            return new IppPrinterOptions();
        }
        return this.ippPrinterOptions;
    }

    public void setIppPrinterOptions(IppPrinterOptions ippPrinterOptions) {
        this.ippPrinterOptions = ippPrinterOptions;
    }

    public void setWatchDogConfiguration(DeviceConfiguration<SerialPort> watchDogConfiguration) {
        this.watchDogConfiguration = watchDogConfiguration;
    }

    public DeviceConfiguration<SerialPort> getWatchDogConfiguration() {
        return this.watchDogConfiguration;
    }

    public DeviceConfiguration<SerialPort> getPinpadConfiguration() {
        return this.pinpadConfiguration;
    }

    public void setPinpadConfiguration(DeviceConfiguration<SerialPort> pinpadConfiguration) {
        this.pinpadConfiguration = pinpadConfiguration;
    }

    public DeviceClass getPrinterClass() {
        return this.printerClass;
    }

    public void setPrinterClass(DeviceClass printerClass) {
        this.printerClass = printerClass;
    }

    public ConnectorConfiguration getDefaultConnectorConfiguration() {
        return this.defaultConnectorConfiguration;
    }

    public DeviceConfiguration<SerialPort> getModemConfiguration() {
        return this.modemConfiguration;
    }

    public void setModemConfiguration(DeviceConfiguration<SerialPort> modemConfiguration) {
        this.modemConfiguration = modemConfiguration;
    }

    public boolean isPppUse() {
        return this.pppUse;
    }

    public void setPppUse(boolean pppUse) {
        this.pppUse = pppUse;
    }

    public boolean isUssdCheck() {
        return this.ussdCheck;
    }

    public void setUssdCheck(boolean ussdCheck) {
        this.ussdCheck = ussdCheck;
    }

    public boolean isSoftwareWatchDogUse() {
        return this.softwareWatchDogUse;
    }

    public void setSoftwareWatchDogUse(boolean softwareWatchDogUse) {
        this.softwareWatchDogUse = softwareWatchDogUse;
    }

    public String getUssdRequest() {
        return this.ussdRequest;
    }

    public void setUssdRequest(String ussdRequest) {
        this.ussdRequest = ussdRequest;
    }

    public boolean isUssdAutoRequest() {
        return this.ussdAutoRequest;
    }

    public void setUssdAutoRequest(boolean ussdAutoRequest) {
        this.ussdAutoRequest = ussdAutoRequest;
    }

    public boolean isFiscalPrinterMode() {
        return this.fiscalPrinterMode;
    }

    public void setFiscalPrinterMode(boolean fiscalPrinterMode) {
        this.fiscalPrinterMode = fiscalPrinterMode;
    }

    public String getPppName() {
        return this.pppName;
    }

    public void setPppName(String pppName) {
        this.pppName = pppName;
    }

    public KkmOptions getKkmOptions() {
        return this.kkmOptions;
    }

    public void setKkmOptions(KkmOptions kkmOptions) {
        this.kkmOptions = kkmOptions;
    }

    public Boolean getOnTop() {
        return this.onTop;
    }

    public void setOnTop(Boolean onTop) {
        this.onTop = onTop;
    }

    public Rendering getRendering() {
        return this.rendering;
    }

    public void setRendering(Rendering rendering) {
        this.rendering = rendering;
    }

    public String getScreenSize() {
        return this.screenSize;
    }

    public void setScreenSize(String screenSize) {
        this.screenSize = screenSize;
    }

    public Boolean getShowCursor() {
        return this.showCursor;
    }

    public void setShowCursor(Boolean showCursor) {
        this.showCursor = showCursor;
    }

    public WatchDogSettings getWatchDogSettings() {
        return this.watchDogSettings;
    }

    public void setWatchDogSettings(WatchDogSettings watchDogSettings) {
        this.watchDogSettings = watchDogSettings;
    }

    public DeviceConfiguration<SerialPort> getBarcodeScannerConfiguration() {
        return this.barcodeScannerConfiguration;
    }

    public void setBarcodeScannerConfiguration(DeviceConfiguration<SerialPort> barcodeScannerConfiguration) {
        this.barcodeScannerConfiguration = barcodeScannerConfiguration;
    }

    public BarcodeScannerType getBarcodeScannerType() {
        return this.barcodeScannerType;
    }

    public void setBarcodeScannerType(BarcodeScannerType barcodeScannerType) {
        this.barcodeScannerType = barcodeScannerType;
    }

    public DeviceConfiguration<SerialPort> getReaderConfiguration() {
        return this.readerConfiguration;
    }

    public void setReaderConfiguration(DeviceConfiguration<SerialPort> readerConfiguration) {
        this.readerConfiguration = readerConfiguration;
    }

    public void setDefaultConnectorConfiguration(ConnectorConfiguration defaultConnectorConfiguration) {
        if (defaultConnectorConfiguration != null) {
            this.defaultConnectorConfiguration = defaultConnectorConfiguration;
            if (this.connectorConfigurations != null) {
                for (ConnectorConfiguration cc : this.connectorConfigurations) {
                    if (!cc.getName().equals(defaultConnectorConfiguration.getName())) continue;
                    this.connectorConfigurations.remove(cc);
                    break;
                }
            } else {
                this.connectorConfigurations = new HashSet<ConnectorConfiguration>();
            }
            this.connectorConfigurations.add(defaultConnectorConfiguration);
        }
    }

    public String getIppPrinterName() {
        return this.ippPrinterName;
    }

    public void setIppPrinterName(String ippPrinterName) {
        this.ippPrinterName = ippPrinterName;
    }

    public Set<ConnectorConfiguration> getConnectorConfigurations() {
        return this.connectorConfigurations;
    }

    public void setConnectorConfigurations(Set<ConnectorConfiguration> coonnectorConfigurations) {
        this.connectorConfigurations = coonnectorConfigurations;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public boolean isAuthProxy() {
        return this.authProxy;
    }

    public void setAuthProxy(boolean authProxy) {
        this.authProxy = authProxy;
    }

    public String getPrintHandler() {
        return this.printHandler;
    }

    public void setPrintHandler(String printHandler) {
        this.printHandler = printHandler;
    }

    public DeviceConfiguration<SerialPort> getCoinHopperConfiguration() {
        return this.coinHopperConfiguration;
    }

    public void setCoinHopperConfiguration(DeviceConfiguration<SerialPort> coinHopperConfiguration) {
        this.coinHopperConfiguration = coinHopperConfiguration;
    }

    public PresentConfiguration getPresentConfiguration() {
        return this.presentConfiguration;
    }

    public void setPresentConfiguration(PresentConfiguration presentConfiguration) {
        this.presentConfiguration = presentConfiguration;
    }

    public CdmConfiguration getCdmConfiguration() {
        return this.cdmConfiguration;
    }

    public void setCdmConfiguration(CdmConfiguration cdmConfiguration) {
        this.cdmConfiguration = cdmConfiguration;
    }

    public DeviceType getProximityType() {
        return this.proximityType;
    }

    public void setProximityType(DeviceType proximityType) {
        this.proximityType = proximityType;
    }

    public String getMppkPath() {
        return this.mppkPath;
    }

    public void setMppkPath(String mppkPath) {
        this.mppkPath = mppkPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateConfiguration() throws ConfigurationException {
        try {
            Element node;
            Element root;
            Document document;
            block81: {
                block83: {
                    Element opt;
                    Element node2;
                    block80: {
                        block82: {
                            Element node3;
                            SerialPort port;
                            this.log.info((Object)"\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u043e\u0431\u043d\u043e\u0432\u043b\u044f\u0442\u044c \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044e");
                            document = DocumentHelper.createDocument();
                            root = document.addElement("configuration");
                            this.log.info((Object)"\u0417\u0430\u043f\u0438\u0441\u044b\u0432\u0430\u044e \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0443 \u0433\u0440\u0430\u0444\u0438\u043a\u0438");
                            Element gui = root.addElement("gui");
                            gui.addAttribute("rendering", this.rendering == null ? Rendering.Quality.toString() : this.rendering.toString());
                            if (this.onTop != null) {
                                gui.addAttribute("on-top", this.onTop.toString());
                            }
                            if (this.showCursor != null) {
                                gui.addAttribute("show-cursor", this.showCursor.toString());
                            }
                            if (this.screenSize != null) {
                                gui.addAttribute("screen-size", this.screenSize);
                            }
                            this.log.info((Object)"\u0421\u043e\u0431\u0438\u0440\u0430\u044e \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u043e\u0440\u0442\u0430\u0445");
                            HashMap<String, SerialParams> serialParams = new HashMap<String, SerialParams>();
                            if (this.cashAcceptorConfiguration != null && (port = this.cashAcceptorConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.coinAcceptorConfiguration != null && (port = this.coinAcceptorConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.coinHopperConfiguration != null && (port = this.coinHopperConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.cardReaderConfiguration != null && (port = this.cardReaderConfiguration.getPort()) != null && port.getType() == PortType.SerialPort) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.posPrinterConfiguration != null && (port = this.posPrinterConfiguration.getPort()) != null && port.getType() == PortType.SerialPort) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.fiscalPrinterConfiguration != null && (port = this.fiscalPrinterConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.watchDogConfiguration != null && (port = this.watchDogConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.modemConfiguration != null && (port = this.modemConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.pinpadConfiguration != null && (port = this.pinpadConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.barcodeScannerConfiguration != null && (port = this.barcodeScannerConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.readerConfiguration != null && (port = this.readerConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.cvdConfiguration != null && (port = this.cvdConfiguration.getPort()) != null) {
                                serialParams.put(port.getName(), port.getParams());
                            }
                            if (this.cdmConfiguration != null && this.cdmConfiguration.getPort() != null) {
                                serialParams.put(this.cdmConfiguration.getPort().getName(), this.cdmConfiguration.getPort().getParams());
                            }
                            Element serial = root.addElement("serial-ports");
                            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0441\u0435\u043a\u0446\u0438\u044e \u0441 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c\u0438 \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0445 \u043f\u043e\u0440\u0442\u043e\u0432");
                            for (String name : serialParams.keySet()) {
                                SerialParams params = (SerialParams)serialParams.get(name);
                                node = serial.addElement("port");
                                node.addAttribute("name", name);
                                node.addAttribute("baud-rate", Integer.toString(params.getSpeed()));
                                node.addAttribute("data-bits", params.getDataBits().getName());
                                node.addAttribute("stop-bits", params.getStopBits().getName());
                                node.addAttribute("parity", params.getParity().toString());
                            }
                            Element cashin = root.addElement("cashin-system");
                            if (this.cashAcceptorConfiguration != null) {
                                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a \u043a\u0443\u043f\u044e\u0440");
                                node3 = cashin.addElement("cash-acceptor");
                                node3.addAttribute("driver", this.cashAcceptorConfiguration.getDeviceType().toString());
                                node3.addAttribute("port", this.cashAcceptorConfiguration.getPort().getName());
                            }
                            if (this.coinAcceptorConfiguration != null) {
                                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a \u043c\u043e\u043d\u0435\u0442");
                                node3 = cashin.addElement("coin-acceptor");
                                node3.addAttribute("driver", this.coinAcceptorConfiguration.getDeviceType().toString());
                                node3.addAttribute("port", this.coinAcceptorConfiguration.getPort().getName());
                            }
                            if (this.cardReaderConfiguration != null) {
                                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043a\u0430\u0440\u0434-\u0440\u0438\u0434\u0435\u0440");
                                node3 = root.addElement("card-reader");
                                node3.addAttribute("driver", this.cardReaderConfiguration.getName());
                                node3.addAttribute("port", this.cardReaderConfiguration.getPort().getName());
                                if (this.cardReaderConfiguration.getPort().getType() == PortType.UsbPort) {
                                    node3.addAttribute("vendor", "" + this.cardReaderConfiguration.getVendor());
                                    node3.addAttribute("product", "" + this.cardReaderConfiguration.getProduct());
                                    node3.addAttribute("serial-no", this.cardReaderConfiguration.getSerialNo());
                                }
                            }
                            this.log.info((Object)"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u044e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043f\u0435\u0447\u0430\u0442\u0438");
                            if (this.printerClass == null) break block82;
                            this.log.info((Object)("\u0422\u0438\u043f \u043f\u0435\u0447\u0430\u0442\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u043e\u0439\u0441\u0442\u0432\u0430: " + this.printerClass));
                            Element print = root.addElement("print-system");
                            print.addAttribute("type", this.printerClass.toString());
                            print.addAttribute("use-pne-sensor", Boolean.toString(this.usePaperNearEndSensor));
                            switch (this.printerClass) {
                                case PosPrinter: {
                                    if (this.posPrinterConfiguration != null) {
                                        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440");
                                        node2 = print.addElement("pos-printer");
                                        node2.addAttribute("driver", this.posPrinterConfiguration.getDeviceType().toString());
                                        node2.addAttribute("port", this.posPrinterConfiguration.getPort().getName());
                                        if (this.printHandler != null) {
                                            node2.addAttribute("handler", this.printHandler);
                                        }
                                        if (this.posPrinterOptions != null) {
                                            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0435\u0447\u0430\u0442\u0438");
                                            opt = node2.addElement("param");
                                            opt.addAttribute("name", "left-margin");
                                            opt.addAttribute("value", Integer.toString(this.posPrinterOptions.getLeftMargin()));
                                            opt = node2.addElement("param");
                                            opt.addAttribute("name", "width");
                                            opt.addAttribute("value", Integer.toString(this.posPrinterOptions.getWidth()));
                                            opt = node2.addElement("param");
                                            opt.addAttribute("name", "scroll");
                                            opt.addAttribute("value", Integer.toString(this.posPrinterOptions.getScroll()));
                                            opt = node2.addElement("param");
                                            opt.addAttribute("name", "span");
                                            opt.addAttribute("value", Integer.toString(this.posPrinterOptions.getSpan()));
                                            opt = node2.addElement("param");
                                            opt.addAttribute("name", "font-size");
                                            opt.addAttribute("value", Integer.toString(this.posPrinterOptions.getFontSize()));
                                            if (this.posPrinterOptions.getEncoding() != null && !this.posPrinterOptions.getEncoding().isEmpty()) {
                                                opt = node2.addElement("param");
                                                opt.addAttribute("name", "encoding");
                                                opt.addAttribute("value", this.posPrinterOptions.getEncoding());
                                            }
                                            if (this.posPrinterOptions.getDispense() != null) {
                                                opt = node2.addElement("param");
                                                opt.addAttribute("name", "dispense");
                                                opt.addAttribute("value", Integer.toString(this.posPrinterOptions.getDispense()));
                                                break;
                                            }
                                        }
                                        break block80;
                                    } else {
                                        this.log.error((Object)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0440\u044b pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                                        break;
                                    }
                                }
                                case IppPrinter: {
                                    node2 = print.addElement("ipp-printer");
                                    node2.addAttribute("name", this.ippPrinterName == null ? "" : this.ippPrinterName);
                                    if (this.ippPrinterOptions != null) {
                                        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0435\u0447\u0430\u0442\u0438");
                                        opt = node2.addElement("param");
                                        opt.addAttribute("name", "font-size");
                                        opt.addAttribute("value", Integer.toString(this.ippPrinterOptions.getFontSize()));
                                        opt = node2.addElement("param");
                                        opt.addAttribute("name", "font-family");
                                        opt.addAttribute("value", this.ippPrinterOptions.getFontFamily() != null ? this.ippPrinterOptions.getFontFamily() : "");
                                        opt = node2.addElement("param");
                                        opt.addAttribute("name", "scroll");
                                        opt.addAttribute("value", Integer.toString(this.ippPrinterOptions.getScroll()));
                                        break;
                                    }
                                    break block80;
                                }
                                case FiscalPrinter: {
                                    if (this.fiscalPrinterConfiguration != null) {
                                        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u043f\u0440\u0438\u043d\u0442\u0435\u0440");
                                        node2 = print.addElement("fiscal-printer");
                                        node2.addAttribute("driver", this.fiscalPrinterConfiguration.getDeviceType().toString());
                                        node2.addAttribute("port", this.fiscalPrinterConfiguration.getPort().getName());
                                        node2.addAttribute("printer-mode", Boolean.toString(this.fiscalPrinterMode));
                                        if (this.kkmOptions != null) {
                                            this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u0435\u0447\u0430\u0442\u0438");
                                            if (this.kkmOptions.getPresenterMode() != null) {
                                                opt = node2.addElement("param");
                                                opt.addAttribute("name", "presenter-mode");
                                                opt.addAttribute("value", Integer.toString(this.kkmOptions.getPresenterMode()));
                                            }
                                            if (this.kkmOptions.getScroll() != null) {
                                                opt = node2.addElement("param");
                                                opt.addAttribute("name", "scroll");
                                                opt.addAttribute("value", Integer.toString(this.kkmOptions.getScroll()));
                                            }
                                            if (this.kkmOptions.getWidth() != null) {
                                                opt = node2.addElement("param");
                                                opt.addAttribute("name", "width");
                                                opt.addAttribute("value", Integer.toString(this.kkmOptions.getWidth()));
                                            }
                                            if (this.kkmOptions.getAdminPassword() != null && !this.kkmOptions.getAdminPassword().isEmpty()) {
                                                opt = node2.addElement("param");
                                                opt.addAttribute("name", "administrator-password");
                                                opt.addAttribute("value", this.kkmOptions.getAdminPassword());
                                            }
                                            if (this.kkmOptions.getOperatorPassword() != null && !this.kkmOptions.getOperatorPassword().isEmpty()) {
                                                opt = node2.addElement("param");
                                                opt.addAttribute("name", "operator-password");
                                                opt.addAttribute("value", this.kkmOptions.getOperatorPassword());
                                                break;
                                            }
                                        }
                                        break block80;
                                    } else {
                                        this.log.error((Object)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0440\u044b \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                                        break;
                                    }
                                }
                                default: {
                                    throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u043f\u0435\u0447\u0430\u0442\u0438");
                                }
                            }
                            break block80;
                        }
                        this.log.error((Object)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u043f\u0435\u0447\u0430\u0442\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
                    }
                    Element watchdog = root.addElement("watchdog-system");
                    if (this.watchDogConfiguration != null) {
                        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0439 \u0442\u0430\u0439\u043c\u0435\u0440");
                        node2 = watchdog.addElement("watch-dog");
                        node2.addAttribute("driver", this.watchDogConfiguration.getDeviceType().toString());
                        node2.addAttribute("port", this.watchDogConfiguration.getPort().getName());
                        if (this.watchDogSettings != null) {
                            if (this.watchDogSettings.getModemChannel() != null) {
                                opt = node2.addElement("param");
                                opt.addAttribute("name", "modem-channel");
                                opt.addAttribute("value", Integer.toString(this.watchDogSettings.getModemChannel()));
                            }
                            if (this.watchDogSettings.getPcResetTimeout() != null) {
                                opt = node2.addElement("param");
                                opt.addAttribute("name", "reset-pc-timeout");
                                opt.addAttribute("value", Integer.toString(this.watchDogSettings.getPcResetTimeout()));
                            }
                            if (!this.watchDogSettings.getSwitchMap().isEmpty()) {
                                Element sws = node2.addElement("switches");
                                for (Integer switchid : this.watchDogSettings.getSwitchMap().keySet()) {
                                    Element sw = sws.addElement("switch");
                                    sw.addAttribute("id", switchid.toString());
                                    EventListener.Event.Channel channel = (EventListener.Event.Channel)this.watchDogSettings.getSwitchMap().get(switchid);
                                    if (channel != null) {
                                        sw.addAttribute("channel", channel.toString());
                                        continue;
                                    }
                                    sw.addAttribute("channel", "none");
                                }
                            }
                        }
                    }
                    Element modem = root.addElement("modem-system");
                    modem.addAttribute("ppp-use", Boolean.toString(this.pppUse));
                    modem.addAttribute("ppp-name", this.pppName);
                    if (this.modemConfiguration != null) {
                        this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043c\u043e\u0434\u0435\u043c");
                        node = modem.addElement("modem");
                        node.addAttribute("driver", this.modemConfiguration.getDeviceType().toString());
                        node.addAttribute("port", this.modemConfiguration.getPort().getName());
                        Element checkBalance = node.addElement("check-balance");
                        checkBalance.addAttribute("active", Boolean.toString(this.ussdCheck));
                        checkBalance.addAttribute("auto-configure", Boolean.toString(this.ussdAutoRequest));
                        checkBalance.addAttribute("request", this.ussdRequest);
                        Element useSoftwareWatchDog = node.addElement("use-software-watchdog");
                        useSoftwareWatchDog.addAttribute("active", Boolean.toString(this.softwareWatchDogUse));
                    }
                    if (this.barcodeScannerType != null) {
                        Element barcode = root.addElement("barcode-scanner");
                        barcode.addAttribute("type", this.barcodeScannerType.toString());
                        if (this.barcodeScannerType == BarcodeScannerType.Serial && this.barcodeScannerConfiguration != null) {
                            barcode.addAttribute("driver", this.barcodeScannerConfiguration.getDeviceType().toString());
                            barcode.addAttribute("port", this.barcodeScannerConfiguration.getPort().getName());
                        }
                    }
                    this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u0435\u043b\u044c \u0431\u0435\u0441\u043a\u043e\u043d\u0442\u0430\u043a\u043d\u044b\u0445 \u043a\u0430\u0440\u0442");
                    if (this.proximityType == null) break block83;
                    Element proximity = root.addElement("proximity-reader");
                    proximity.addAttribute("driver", this.proximityType.toString());
                    if (this.proximityType == DeviceType.RosanProximityReader) {
                        if (this.mppkPath != null && !"".equals(this.mppkPath)) {
                            proximity.addAttribute("mppkPath", this.mppkPath);
                            break block81;
                        } else {
                            this.log.error((Object)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b Rosan \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u0435\u043b\u044f");
                        }
                        break block81;
                    } else if (this.readerConfiguration != null) {
                        proximity.addAttribute("port", this.readerConfiguration.getPort().getName());
                        break block81;
                    } else {
                        this.log.error((Object)"\u041d\u0435 \u0437\u0430\u0434\u0430\u043d\u044b \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0431\u0435\u0441\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u0435\u043b\u044f");
                    }
                    break block81;
                }
                this.log.error((Object)"\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
            }
            if (this.pinpadConfiguration != null) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043f\u0438\u043d\u043f\u0430\u0434");
                node = root.addElement("pinpad");
                node.addAttribute("driver", this.pinpadConfiguration.getDeviceType().toString());
                node.addAttribute("port", this.pinpadConfiguration.getPort().getName());
            }
            if (this.coinHopperConfiguration != null) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0445\u043e\u043f\u043f\u0435\u0440");
                node = root.addElement("hopper");
                node.addAttribute("driver", this.coinHopperConfiguration.getDeviceType().toString());
                node.addAttribute("port", this.coinHopperConfiguration.getPort().getName());
            }
            if (this.cvdConfiguration != null) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440 \u043a\u0430\u0440\u0442");
                node = root.addElement("cvd");
                node.addAttribute("driver", this.cvdConfiguration.getDeviceType().toString());
                node.addAttribute("port", this.cvdConfiguration.getPort().getName());
            }
            if (this.cdmConfiguration != null) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438");
                node = root.addElement("cdm");
                node.addAttribute("driver", this.cdmConfiguration.getType().toString());
                node.addAttribute("port", this.cdmConfiguration.getPort().getName());
            }
            if (this.cardModuleType != null) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c");
                node = root.addElement("card-module");
                node.addAttribute("type", this.cardModuleType);
            }
            if (this.presentConfiguration != null) {
                node = root.addElement("present-module");
                node.addAttribute("type", this.presentConfiguration.getType());
                if (this.presentConfiguration.getOptions() != null) {
                    node.addAttribute("cost", Integer.toString(this.presentConfiguration.getOptions().getCost()));
                }
                if (this.presentConfiguration.getNetworkOptions() != null && "NetworkModule".equals(this.presentConfiguration.getType())) {
                    Object dno;
                    Element nm = node.addElement("network-module");
                    if (this.presentConfiguration.getDriver() != null && !this.presentConfiguration.getDriver().isEmpty()) {
                        nm.addAttribute("type", this.presentConfiguration.getDriver());
                    }
                    if ((dno = this.presentConfiguration.getNetworkOptions()).getHost() != null && !dno.getHost().isEmpty()) {
                        nm.addAttribute("host", dno.getHost());
                    }
                    if (dno.getPort() != null) {
                        nm.addAttribute("port", Integer.toString(dno.getPort()));
                    }
                }
            }
            Element proxy = root.addElement("proxy-server");
            proxy.addAttribute("use", Boolean.toString(this.useProxy));
            if (this.proxyHost != null) {
                proxy.addAttribute("host", this.proxyHost);
            }
            if (this.proxyPort != null) {
                proxy.addAttribute("port", this.proxyPort);
            }
            proxy.addAttribute("auth", Boolean.toString(this.authProxy));
            if (this.proxyUser != null) {
                proxy.addAttribute("username", this.proxyUser);
            }
            if (this.proxyPassword != null) {
                proxy.addAttribute("password", this.proxyPassword);
            }
            Element server = root.addElement("server");
            if (this.connectorConfigurations != null) {
                this.log.info((Object)"\u0414\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u043e\u0432");
                for (ConnectorConfiguration config : this.connectorConfigurations) {
                    Element connectorConfig = server.addElement("connector");
                    connectorConfig.addAttribute("name", config.getName());
                    connectorConfig.addAttribute("type", config.getType().toString());
                    Map params = config.getParams();
                    for (String key : params.keySet()) {
                        Element param = connectorConfig.addElement("param");
                        param.addAttribute("name", key);
                        param.addAttribute("value", (String)params.get(key));
                    }
                }
            }
            if (this.defaultConnectorConfiguration != null) {
                this.log.info((Object)"\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u044e \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430");
                server.addAttribute("connector", this.defaultConnectorConfiguration.getName());
            }
            this.log.info((Object)("Length of configuration.xml \u043f\u0435\u0440\u0435\u0434 \u0437\u0430\u043f\u0438\u0441\u044c\u044e: " + new File(this.getApplicationDir() + "/configuration.xml").length()));
            this.log.info((Object)"\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0437\u0430\u043f\u0438\u0441\u044c \u0432 \u0444\u0430\u0439\u043b");
            PrintWriter out = null;
            try {
                out = new PrintWriter(this.getApplicationDir() + "/configuration.xml", "utf-8");
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter((Writer)out, format);
                this.log.info((Object)("Name of document.RootElement: " + document.getRootElement().getName()));
                writer.write(document);
                writer.close();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)out);
            this.log.info((Object)"\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0441\u043e\u0445\u0440\u0430\u043d\u0435\u043d\u0430");
            this.log.info((Object)("Length of configuration.xml \u043f\u043e\u0441\u043b\u0435 \u0437\u0430\u043f\u0438\u0441\u0438: " + new File(this.getApplicationDir() + "/configuration.xml").length()));
            return;
        }
        catch (Exception ex) {
            this.log.error((Object)ex, (Throwable)ex);
            throw new ConfigurationException("\u041d\u0435 \u0441\u043c\u043e\u0433\u043b\u0438 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u043d\u043e\u0432\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b", ex);
        }
    }

    public String getCardModuleType() {
        return this.cardModuleType;
    }

    public void setCardModuleType(String cardModuleType) {
        this.cardModuleType = cardModuleType;
    }

    public boolean isCashEmulator() {
        return this.getCashAcceptorConfiguration() != null && (this.getCashAcceptorConfiguration().getDeviceType() == DeviceType.ValidatorStub || this.getCashAcceptorConfiguration().getDeviceType() == DeviceType.ValidatorStub2);
    }

    public void readConfiguration() throws ConfigurationException {
        block146: {
            Object pr;
            DataBits db;
            SerialPort conn;
            DeviceType type;
            String port;
            String proto;
            List params;
            Node node;
            Element root;
            Document document;
            block145: {
                String t;
                block144: {
                    SerialPort conn2;
                    SerialParams params2;
                    StopBits sb;
                    block143: {
                        Element proxy;
                        try {
                            this.baseDir = FileUtil.checkDir((String)PathUtils.getAppHome());
                        }
                        catch (FileUtilException ex) {
                            throw new ConfigurationException(ex);
                        }
                        document = null;
                        root = null;
                        try {
                            this.log.info((Object)"*********************************************************************");
                            this.log.info((Object)"\u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0447\u0442\u0435\u043d\u0438\u0435 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438");
                            SAXReader reader = new SAXReader();
                            document = reader.read(new File(this.getApplicationDir() + "/configuration.xml"));
                            root = document.getRootElement();
                        }
                        catch (Exception ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438", (Throwable)ex);
                            return;
                        }
                        this.log.info((Object)"\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u0430, \u0441\u043e\u0437\u0434\u0430\u044e \u043e\u0431\u044a\u0435\u043a\u0442\u044b");
                        Node gui = document.selectSingleNode("//gui");
                        if (gui != null) {
                            String rnd = gui.valueOf("@rendering");
                            if (rnd != null && !rnd.isEmpty()) {
                                try {
                                    this.rendering = Rendering.valueOf((String)rnd);
                                    this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0432\u0430\u0440\u0438\u0430\u043d\u0442 \u043e\u0442\u0440\u0438\u0441\u043e\u0432\u043a\u0438 \u0433\u0440\u0430\u0444\u0438\u043a\u0438: " + GuiOptions.getRendering()));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (gui.valueOf("@show-cursor") != null && !gui.valueOf("@show-cursor").isEmpty()) {
                                this.showCursor = Boolean.parseBoolean(gui.valueOf("@show-cursor"));
                            }
                            if (gui.valueOf("@on-top") != null && !gui.valueOf("@on-top").isEmpty()) {
                                this.onTop = Boolean.parseBoolean(gui.valueOf("@on-top"));
                            }
                            this.screenSize = gui.valueOf("@screen-size");
                        }
                        if ((proxy = root.element("proxy-server")) != null) {
                            String param = proxy.attributeValue("use");
                            this.useProxy = param == null ? false : Boolean.parseBoolean(param);
                            this.proxyHost = proxy.attributeValue("host");
                            this.proxyPort = proxy.attributeValue("port");
                            param = proxy.attributeValue("auth");
                            this.authProxy = param == null ? false : Boolean.parseBoolean(param);
                            this.proxyUser = proxy.attributeValue("username");
                            this.proxyPassword = proxy.attributeValue("password");
                        }
                        try {
                            node = document.selectSingleNode("//server");
                            if (node != null) {
                                this.log.info((Object)"************ \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 ************");
                                String defaultConnectorName = node.valueOf("@connector");
                                this.log.info((Object)("\u0418\u043c\u044f \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u043e: " + defaultConnectorName));
                                HashSet<ConnectorConfiguration> connConfigs = new HashSet<ConnectorConfiguration>();
                                List configs = document.selectNodes("//server/connector");
                                if (configs != null) {
                                    this.log.info((Object)("\u041d\u0430\u0439\u0434\u0435\u043d\u043e " + configs.size() + " \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u043e\u0432"));
                                    for (Object objectConfig : configs) {
                                        Element config = (Element)objectConfig;
                                        String name = config.valueOf("@name");
                                        ConnectorType type2 = ConnectorType.valueOf((String)config.valueOf("@type"));
                                        this.log.info((Object)("\u0421\u043b\u0435\u0434\u0443\u044e\u0449\u0438\u0439 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440 " + name + " \u0442\u0438\u043f: " + type2));
                                        HashMap<String, String> paramsMap = new HashMap<String, String>();
                                        params = config.elements();
                                        if (params != null) {
                                            for (Object objectParam : params) {
                                                Node param = (Node)objectParam;
                                                paramsMap.put(param.valueOf("@name"), param.valueOf("@value"));
                                            }
                                        }
                                        this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b, \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u044e \u0432 \u0441\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439");
                                        ConnectorConfiguration connConfig = new ConnectorConfiguration(name, type2, paramsMap);
                                        connConfigs.add(connConfig);
                                        if (!defaultConnectorName.equals(connConfig.getName())) continue;
                                        this.defaultConnectorConfiguration = connConfig;
                                        this.log.info((Object)"\u042d\u0442\u043e\u0442 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u043a\u0430\u043a \u0442\u0435\u043a\u0443\u0449\u0438\u0439");
                                    }
                                    this.log.info((Object)"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u0441\u043f\u0438\u0441\u043e\u043a \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0439");
                                    this.setConnectorConfigurations(connConfigs);
                                } else {
                                    this.log.error((Object)"\u041d\u0438 \u043e\u0434\u043d\u043e\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u043a\u043e\u043d\u043d\u0435\u043a\u0442\u043e\u0440\u0430 \u043d\u0435 \u0431\u044b\u043b\u043e \u043d\u0430\u0439\u0434\u0435\u043d\u043e");
                                }
                            } else {
                                this.log.error((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430");
                            }
                        }
                        catch (Exception ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0430", (Throwable)ex);
                        }
                        try {
                            node = document.selectSingleNode("//cashin-system/cash-acceptor");
                            if (node != null) {
                                this.log.info((Object)"************ \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 ************");
                                proto = node.valueOf("@driver");
                                port = node.valueOf("@port");
                                type = DeviceType.valueOf((String)proto);
                                this.log.info((Object)("\u0422\u0438\u043f \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port));
                                conn = new SerialPort(port);
                                this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                                node = document.selectSingleNode("//serial-ports/port[@name=//cashin-system/cash-acceptor/@port]");
                                if (node != null) {
                                    this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                                    int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                                    db = DataBits.value((String)node.valueOf("@data-bits"));
                                    sb = StopBits.value((String)node.valueOf("@stop-bits"));
                                    pr = Parity.valueOf((String)node.valueOf("@parity"));
                                    params2 = new SerialParams(speed, db, sb, (Parity)pr);
                                    conn.putParams(params2);
                                    this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                                }
                                this.setCashAcceptorConfiguration(new DeviceConfiguration<SerialPort>(type, conn));
                                this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                            } else {
                                this.log.error((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                            }
                        }
                        catch (Exception ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043a\u0443\u043f\u044e\u0440\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430", (Throwable)ex);
                        }
                        try {
                            node = document.selectSingleNode("//cvd");
                            if (node != null) {
                                this.log.info((Object)"************ \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043a\u0430\u0440\u0442 ************");
                                proto = node.valueOf("@driver");
                                port = node.valueOf("@port");
                                type = DeviceType.valueOf((String)proto);
                                this.log.info((Object)("\u0422\u0438\u043f \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port));
                                conn = new SerialPort(port);
                                this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                                node = document.selectSingleNode("//serial-ports/port[@name=//cvd/@port]");
                                if (node != null) {
                                    this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                                    int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                                    db = DataBits.value((String)node.valueOf("@data-bits"));
                                    sb = StopBits.value((String)node.valueOf("@stop-bits"));
                                    pr = Parity.valueOf((String)node.valueOf("@parity"));
                                    params2 = new SerialParams(speed, db, sb, (Parity)pr);
                                    conn.putParams(params2);
                                    this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                                }
                                this.setCvdConfiguration(new DeviceConfiguration<SerialPort>(type, conn));
                                this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043a\u0430\u0440\u0442 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                            } else {
                                this.log.error((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043a\u0430\u0440\u0442");
                            }
                        }
                        catch (Exception ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043a\u0430\u0440\u0442", (Throwable)ex);
                        }
                        try {
                            node = document.selectSingleNode("//cdm");
                            if (node != null) {
                                this.log.info((Object)"************ \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 ************");
                                proto = node.valueOf("@driver");
                                port = node.valueOf("@port");
                                type = DeviceType.valueOf((String)proto);
                                this.log.info((Object)("\u0422\u0438\u043f \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port));
                                conn = new SerialPort(port);
                                this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                                node = document.selectSingleNode("//serial-ports/port[@name=//cdm/@port]");
                                if (node != null) {
                                    this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                                    int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                                    db = DataBits.value((String)node.valueOf("@data-bits"));
                                    sb = StopBits.value((String)node.valueOf("@stop-bits"));
                                    pr = Parity.valueOf((String)node.valueOf("@parity"));
                                    params2 = new SerialParams(speed, db, sb, (Parity)pr);
                                    conn.putParams(params2);
                                    this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                                }
                                this.setCdmConfiguration(new CdmConfiguration(conn, type));
                                this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                            } else {
                                this.log.error((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438");
                            }
                        }
                        catch (Exception ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0434\u0438\u0441\u043f\u0435\u043d\u0441\u0435\u0440\u0430 \u043d\u0430\u043b\u0438\u0447\u043d\u043e\u0441\u0442\u0438", (Throwable)ex);
                        }
                        try {
                            node = document.selectSingleNode("//cashin-system/coin-acceptor");
                            if (node != null) {
                                this.log.info((Object)"************ \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 ************");
                                proto = node.valueOf("@driver");
                                port = node.valueOf("@port");
                                type = DeviceType.valueOf((String)proto);
                                this.log.info((Object)("\u0422\u0438\u043f \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port));
                                conn = new SerialPort(port);
                                this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                                node = document.selectSingleNode("//serial-ports/port[@name=//cashin-system/coin-acceptor/@port]");
                                if (node != null) {
                                    this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                                    int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                                    db = DataBits.value((String)node.valueOf("@data-bits"));
                                    sb = StopBits.value((String)node.valueOf("@stop-bits"));
                                    pr = Parity.valueOf((String)node.valueOf("@parity"));
                                    params2 = new SerialParams(speed, db, sb, (Parity)pr);
                                    conn.putParams(params2);
                                    this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                                }
                                this.setCoinAcceptorConfiguration(new DeviceConfiguration<SerialPort>(type, conn));
                                this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                            } else {
                                this.log.error((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430");
                            }
                        }
                        catch (Exception ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043c\u043e\u043d\u0435\u0442\u043e\u043f\u0440\u0438\u0435\u043c\u043d\u0438\u043a\u0430", (Throwable)ex);
                        }
                        try {
                            node = document.selectSingleNode("//card-reader");
                            if (node != null) {
                                this.log.info((Object)"************ \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043a\u0430\u0440\u0434-\u0440\u0438\u0434\u0435\u0440\u0430 ************");
                                proto = node.valueOf("@driver");
                                port = node.valueOf("@port");
                                this.log.info((Object)("\u0422\u0438\u043f \u043a\u0430\u0440\u0434-\u0440\u0438\u0434\u0435\u0440\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + proto + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port));
                                conn2 = new SerialPort(port);
                                this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                                node = document.selectSingleNode("//serial-ports/port[@name=//card-reader/@port]");
                                if (node != null) {
                                    this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                                    int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                                    DataBits db2 = DataBits.value((String)node.valueOf("@data-bits"));
                                    StopBits sb2 = StopBits.value((String)node.valueOf("@stop-bits"));
                                    Parity pr2 = Parity.valueOf((String)node.valueOf("@parity"));
                                    SerialParams params3 = new SerialParams(speed, db2, sb2, pr2);
                                    conn2.putParams(params3);
                                    this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                                }
                                CardReaderConfiguration<SerialPort> crc = new CardReaderConfiguration<SerialPort>(proto, conn2);
                                if (node.valueOf("@vendor").matches("^\\d{1,10}$")) {
                                    try {
                                        crc.setVendor(Integer.parseInt(node.valueOf("@vendor")));
                                    }
                                    catch (Exception db2) {
                                        // empty catch block
                                    }
                                }
                                if (node.valueOf("@product").matches("^\\d{1,10}$")) {
                                    try {
                                        crc.setProduct(Integer.parseInt(node.valueOf("@vendor")));
                                    }
                                    catch (Exception db2) {
                                        // empty catch block
                                    }
                                }
                                if (!node.valueOf("@serial-no").isEmpty()) {
                                    crc.setSerialNo(node.valueOf("@serial-no"));
                                }
                                this.setCardReaderConfiguration(crc);
                                this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043a\u0430\u0440\u0434-\u0440\u0438\u0434\u0435\u0440\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                                break block143;
                            }
                            this.log.error((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 \u043a\u0430\u0440\u0434-\u0440\u0438\u0434\u0435\u0440\u0430");
                        }
                        catch (Exception ex) {
                            this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043a\u0430\u0440\u0434-\u0440\u0438\u0434\u0435\u0440\u0430", (Throwable)ex);
                        }
                    }
                    try {
                        this.log.info((Object)"************ \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0431\u0435\u0441\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u0435\u043b\u044f ************");
                        Element proximity = root.element("proximity-reader");
                        if (proximity != null) {
                            t = proximity.valueOf("@driver");
                            try {
                                this.proximityType = DeviceType.valueOf((String)t);
                            }
                            catch (Throwable ex) {
                                throw new IllegalArgumentException("\u041d\u0435 \u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430", ex);
                            }
                            if (this.proximityType == DeviceType.RosanProximityReader) {
                                String path = proximity.valueOf("@mppkPath");
                                this.log.info((Object)("\u0422\u0438\u043f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + this.proximityType.toString() + " \u041f\u0443\u0442\u044c \u0434\u043e \u041c\u041f\u041f\u041a: " + path));
                                this.setMppkPath(path);
                                this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0431\u0435\u0441\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u0435\u043b\u044f \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                            } else {
                                port = proximity.valueOf("@port");
                                this.log.info((Object)("\u0422\u0438\u043f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + this.proximityType + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port));
                                conn2 = new SerialPort(port);
                                this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                                Node node2 = document.selectSingleNode("//serial-ports/port[@name=//proximity-reader/@port]");
                                if (node2 != null) {
                                    this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                                    int speed = Integer.parseInt(node2.valueOf("@baud-rate"));
                                    db = DataBits.value((String)node2.valueOf("@data-bits"));
                                    sb = StopBits.value((String)node2.valueOf("@stop-bits"));
                                    pr = Parity.valueOf((String)node2.valueOf("@parity"));
                                    params2 = new SerialParams(speed, db, sb, (Parity)pr);
                                    conn2.putParams(params2);
                                    this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                                }
                                this.setReaderConfiguration(new DeviceConfiguration<SerialPort>(this.proximityType, conn2));
                                this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0431\u0435\u0441\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u0435\u043b\u044f \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                            }
                            break block144;
                        }
                        this.log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0431\u0435\u0441\u043a\u043e\u043d\u0442\u0430\u043a\u0442\u043d\u043e\u0433\u043e \u0441\u0447\u0438\u0442\u044b\u0432\u0430\u0442\u0435\u043b\u044f", (Throwable)ex);
                    }
                }
                try {
                    this.log.info((Object)"*************** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 ***************");
                    Element printSystem = root.element("print-system");
                    if (printSystem != null) {
                        t = printSystem.valueOf("@type");
                        if (t == null || t.length() == 0) {
                            throw new IllegalArgumentException("\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d \u043a\u043b\u0430\u0441\u0441 \u043f\u0435\u0447\u0430\u0442\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430 [IppPrinter,PosPrinter,FiscalPrinter]");
                        }
                        try {
                            this.printerClass = DeviceClass.valueOf((String)printSystem.valueOf("@type"));
                            String ups = printSystem.attributeValue("use-pne-sensor");
                            if (ups != null && !ups.isEmpty()) {
                                this.usePaperNearEndSensor = Boolean.parseBoolean(ups);
                            }
                        }
                        catch (Throwable ex) {
                            throw new IllegalArgumentException("\u041d\u0435 \u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u043a\u043b\u0430\u0441\u0441 \u043f\u0435\u0447\u0430\u0442\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430. \u041f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f - [IppPrinter,PosPrinter,FiscalPrinter]", ex);
                        }
                        switch (this.printerClass) {
                            case IppPrinter: {
                                this.log.info((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u0440\u0438\u043d\u0442\u0435\u0440 - \u043f\u0440\u0438\u043d\u0442\u0435\u0440 \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e \u041e\u0421");
                                Node node3 = document.selectSingleNode("//print-system/ipp-printer");
                                if (node3 == null) break;
                                this.ippPrinterName = node3.valueOf("@name");
                                break;
                            }
                            case PosPrinter: {
                                String port2;
                                String proto2;
                                this.log.info((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u0440\u0438\u043d\u0442\u0435\u0440 - pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440");
                                Node node3 = document.selectSingleNode("//print-system/pos-printer");
                                if (node3 != null) {
                                    ParallelPort conn3;
                                    proto2 = node3.valueOf("@driver");
                                    port2 = node3.valueOf("@port");
                                    this.printHandler = node3.valueOf("@handler");
                                    DeviceType type3 = DeviceType.valueOf((String)proto2);
                                    this.log.info((Object)("\u0422\u0438\u043f pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type3 + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port2));
                                    PortType pType = PortScanner.getType((String)port2);
                                    if (pType == null) {
                                        this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043e\u0442\u0441\u0443\u0442\u0441\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435, \u0435\u0433\u043e \u0442\u0438\u043f \u043d\u0435\u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d. \u041f\u044b\u0442\u0430\u0435\u043c\u0441\u044f \u043f\u0440\u0435\u0434\u043f\u043e\u043b\u043e\u0436\u0438\u0442\u044c \u0442\u0438\u043f \u043f\u043e\u0440\u0442\u0430");
                                        pType = PortScanner.suggestType((String)port2);
                                        this.log.info((Object)("\u041f\u0440\u0435\u0434\u043f\u043e\u043b\u0430\u0433\u0430\u0435\u043c\u044b\u0439 \u0442\u0438\u043f \u043f\u043e\u0440\u0442\u0430: " + pType));
                                    }
                                    if (pType == PortType.ParallelPort) {
                                        this.log.info((Object)("\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043a \u043f\u0430\u0440\u0430\u043b\u043b\u0435\u043b\u044c\u043d\u043e\u043c\u0443 \u043f\u043e\u0440\u0442\u0443: " + port2));
                                        conn3 = new ParallelPort(port2);
                                        this.log.info((Object)"\u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d");
                                    } else if (pType == PortType.SerialPort) {
                                        this.log.info((Object)("\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043a \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u043c\u0443 \u043f\u043e\u0440\u0442\u0443: " + port2));
                                        SerialPort serialPort = new SerialPort(port2);
                                        this.log.info((Object)"\u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d");
                                        node3 = document.selectSingleNode("//serial-ports/port[@name=//print-system/pos-printer/@port]");
                                        if (node3 != null) {
                                            this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                                            int speed = Integer.parseInt(node3.valueOf("@baud-rate"));
                                            DataBits db3 = DataBits.value((String)node3.valueOf("@data-bits"));
                                            StopBits sb = StopBits.value((String)node3.valueOf("@stop-bits"));
                                            Parity pr3 = Parity.valueOf((String)node3.valueOf("@parity"));
                                            SerialParams params4 = new SerialParams(speed, db3, sb, pr3);
                                            serialPort.putParams(params4);
                                            this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                                        }
                                        conn3 = serialPort;
                                    } else {
                                        this.log.info((Object)("\u041f\u0440\u0438\u043d\u0442\u0435\u0440 \u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043a usb->lpt \u043f\u043e\u0440\u0442\u0443: " + port2));
                                        UsbPort usbPort = new UsbPort(port2);
                                        this.log.info((Object)"\u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d");
                                        conn3 = usbPort;
                                    }
                                    this.setPosPrinterConfiguration(new DeviceConfiguration<ParallelPort>(type3, conn3));
                                    this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e, \u0441\u043e\u0437\u0434\u0430\u044e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0447\u0435\u043a\u043e\u0432");
                                    break;
                                }
                                this.log.error((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                                break;
                            }
                            case FiscalPrinter: {
                                String port2;
                                String proto2;
                                this.log.info((Object)"\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u0440\u0438\u043d\u0442\u0435\u0440 - \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u044b\u0439 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440");
                                Node node3 = document.selectSingleNode("//print-system/fiscal-printer");
                                if (node3 != null) {
                                    proto2 = node3.valueOf("@driver");
                                    port2 = node3.valueOf("@port");
                                    this.fiscalPrinterMode = Boolean.parseBoolean(node3.valueOf("@printer-mode"));
                                    DeviceType type4 = DeviceType.valueOf((String)proto2);
                                    this.log.info((Object)("\u0422\u0438\u043f \u0444\u0438\u0441\u043a\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type4 + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port2));
                                    SerialPort conn4 = new SerialPort(port2);
                                    this.log.info((Object)"\u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d");
                                    node3 = document.selectSingleNode("//serial-ports/port[@name=//print-system/fiscal-printer/@port]");
                                    if (node3 != null) {
                                        this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                                        int speed = Integer.parseInt(node3.valueOf("@baud-rate"));
                                        DataBits db4 = DataBits.value((String)node3.valueOf("@data-bits"));
                                        StopBits sb = StopBits.value((String)node3.valueOf("@stop-bits"));
                                        Parity pr4 = Parity.valueOf((String)node3.valueOf("@parity"));
                                        SerialParams params5 = new SerialParams(speed, db4, sb, pr4);
                                        conn4.putParams(params5);
                                        this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                                    }
                                    this.setFiscalPrinterConfiguration(new DeviceConfiguration<SerialPort>(type4, conn4));
                                    this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e, \u0441\u043e\u0437\u0434\u0430\u044e \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0447\u0435\u043a\u043e\u0432");
                                    break;
                                }
                                this.log.error((Object)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0430 pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430");
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("\u041d\u0435\u0432\u0435\u0440\u043d\u043e \u0443\u043a\u0430\u0437\u0430\u043d \u0442\u0438\u043f \u043f\u0435\u0447\u0430\u0442\u0430\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
                            }
                        }
                        if (this.printerClass == DeviceClass.PosPrinter) {
                            this.posPrinterOptions = new PosPrinterOptions();
                            this.posPrinterOptions.setLeftMargin(this.readInt(document.selectSingleNode("//print-system/pos-printer/param[@name='left-margin']"), AppDefaults.getInstance().getPosPrinterLeftMargin()));
                            this.posPrinterOptions.setWidth(this.readInt(document.selectSingleNode("//print-system/pos-printer/param[@name='width']"), AppDefaults.getInstance().getPosPrinterPrintWidth()));
                            this.posPrinterOptions.setScroll(this.readInt(document.selectSingleNode("//print-system/pos-printer/param[@name='scroll']"), AppDefaults.getInstance().getPosPrinterScroll()));
                            this.posPrinterOptions.setSpan(this.readInt(document.selectSingleNode("//print-system/pos-printer/param[@name='span']"), AppDefaults.getInstance().getPosPrinterSpan()));
                            this.posPrinterOptions.setFontSize(this.readInt(document.selectSingleNode("//print-system/pos-printer/param[@name='font-size']"), AppDefaults.getInstance().getPosPrinterFontSize()));
                            this.posPrinterOptions.setEncoding(this.readString(document.selectSingleNode("//print-system/pos-printer/param[@name='encoding']"), ""));
                            this.posPrinterOptions.setDispense(this.readInt((Element)document.selectSingleNode("//print-system/pos-printer/param[@name='dispense']")));
                            this.log.info((Object)("params=" + this.posPrinterOptions));
                        } else if (this.printerClass == DeviceClass.IppPrinter) {
                            this.ippPrinterOptions = new IppPrinterOptions();
                            this.ippPrinterOptions.setFontSize(this.readInt(document.selectSingleNode("//print-system/ipp-printer/param[@name='font-size']"), 9));
                            this.ippPrinterOptions.setFontFamily(this.readString(document.selectSingleNode("//print-system/ipp-printer/param[@name='font-family']"), null));
                            this.ippPrinterOptions.setScroll(this.readInt(document.selectSingleNode("//print-system/ipp-printer/param[@name='scroll']"), 10));
                            this.log.info((Object)("params=" + this.ippPrinterOptions));
                        } else if (this.printerClass == DeviceClass.FiscalPrinter) {
                            this.kkmOptions = new KkmOptions();
                            Node opt = document.selectSingleNode("//print-system/fiscal-printer/param[@name='presenter-mode']");
                            if (opt != null && opt.valueOf("@value") != null && opt.valueOf("@value").matches("^\\d+$")) {
                                this.kkmOptions.setPresenterMode(Integer.valueOf(Integer.parseInt(opt.valueOf("@value"))));
                            }
                            if ((opt = document.selectSingleNode("//print-system/fiscal-printer/param[@name='scroll']")) != null && opt.valueOf("@value") != null && opt.valueOf("@value").matches("^\\d+$")) {
                                this.kkmOptions.setScroll(Integer.valueOf(Integer.parseInt(opt.valueOf("@value"))));
                            }
                            if ((opt = document.selectSingleNode("//print-system/fiscal-printer/param[@name='width']")) != null && opt.valueOf("@value") != null && opt.valueOf("@value").matches("^\\d+$")) {
                                this.kkmOptions.setWidth(Integer.valueOf(Integer.parseInt(opt.valueOf("@value"))));
                            }
                            if ((opt = document.selectSingleNode("//print-system/fiscal-printer/param[@name='administrator-password']")) != null && opt.valueOf("@value") != null && !opt.valueOf("@value").isEmpty()) {
                                this.kkmOptions.setAdminPassword(opt.valueOf("@value"));
                            }
                            if ((opt = document.selectSingleNode("//print-system/fiscal-printer/param[@name='operator-password']")) != null && opt.valueOf("@value") != null && !opt.valueOf("@value").isEmpty()) {
                                this.kkmOptions.setOperatorPassword(opt.valueOf("@value"));
                            }
                            this.log.info((Object)("params=" + this.kkmOptions));
                        }
                        break block145;
                    }
                    this.log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u043f\u0435\u0447\u0430\u0442\u0435\u044e\u0449\u0435\u0433\u043e \u0443\u0441\u0442\u0440\u043e\u0439\u0441\u0442\u0432\u0430");
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 pos-\u043f\u0440\u0438\u043d\u0442\u0435\u0440\u0430", (Throwable)ex);
                }
            }
            try {
                node = document.selectSingleNode("//watchdog-system/watch-dog");
                if (node != null) {
                    this.log.info((Object)"*********** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430 *********");
                    proto = node.valueOf("@driver");
                    port = node.valueOf("@port");
                    type = DeviceType.valueOf((String)proto);
                    this.log.info((Object)("\u0422\u0438\u043f \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port));
                    conn = new SerialPort(port);
                    this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                    node = document.selectSingleNode("//serial-ports/port[@name=//watchdog-system/watch-dog/@port]");
                    if (node != null) {
                        this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                        int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                        db = DataBits.value((String)node.valueOf("@data-bits"));
                        StopBits sb = StopBits.value((String)node.valueOf("@stop-bits"));
                        pr = Parity.valueOf((String)node.valueOf("@parity"));
                        SerialParams params6 = new SerialParams(speed, db, sb, (Parity)pr);
                        conn.putParams(params6);
                        this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                    }
                    this.setWatchDogConfiguration(new DeviceConfiguration<SerialPort>(type, conn));
                    this.watchDogSettings = new WatchDogSettings();
                    Node wdsNode = document.selectSingleNode("//watchdog-system/watch-dog/param[@name='modem-channel']");
                    if (wdsNode != null && wdsNode.valueOf("@value") != null && wdsNode.valueOf("@value").matches("^\\d+$")) {
                        this.watchDogSettings.setModemChannel(Integer.valueOf(Integer.parseInt(wdsNode.valueOf("@value"))));
                    }
                    if ((wdsNode = document.selectSingleNode("//watchdog-system/watch-dog/param[@name='reset-pc-timeout']")) != null && wdsNode.valueOf("@value") != null && wdsNode.valueOf("@value").matches("^\\d+$")) {
                        this.watchDogSettings.setPcResetTimeout(Integer.valueOf(Integer.parseInt(wdsNode.valueOf("@value"))));
                    }
                    List swNodes = document.selectNodes("//watchdog-system/watch-dog/switches/switch");
                    WatchDogDescriptor wdtDescriptor = WatchDogFactory.createDescriptor((DeviceType)type);
                    if (wdtDescriptor.isAllowRemap()) {
                        if (swNodes.isEmpty()) {
                            this.watchDogSettings.setSwitchMap(wdtDescriptor.getDefaultMapping());
                        } else {
                            for (Node swNode : swNodes) {
                                String id = swNode.valueOf("@id");
                                String channel = swNode.valueOf("@channel");
                                if (id == null || channel == null || !id.matches("^\\d+$")) continue;
                                if ("none".equals(channel)) {
                                    this.watchDogSettings.addSwitch(Integer.parseInt(id), null);
                                    continue;
                                }
                                this.watchDogSettings.addSwitch(Integer.parseInt(id), EventListener.Event.Channel.valueOf((String)channel));
                            }
                        }
                    }
                    this.log.info((Object)("C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e: " + this.watchDogSettings));
                } else {
                    this.log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u043e\u0439 \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430");
                }
            }
            catch (Exception ex) {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0441\u0442\u043e\u0440\u043e\u0436\u0435\u0432\u043e\u0433\u043e \u0442\u0430\u0439\u043c\u0435\u0440\u0430: " + ex.getMessage()));
            }
            try {
                node = document.selectSingleNode("//barcode-scanner");
                if (node != null) {
                    this.log.info((Object)"*********** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u043e\u0432 *********");
                    this.barcodeScannerType = BarcodeScannerType.valueOf((String)node.valueOf("@type"));
                    if (this.barcodeScannerType == BarcodeScannerType.Serial) {
                        proto = node.valueOf("@driver");
                        port = node.valueOf("@port");
                        type = DeviceType.valueOf((String)proto);
                        this.log.info((Object)("\u0422\u0438\u043f \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port));
                        conn = new SerialPort(port);
                        this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                        node = document.selectSingleNode("//serial-ports/port[@name=//barcode-scanner/@port]");
                        if (node != null) {
                            this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                            int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                            db = DataBits.value((String)node.valueOf("@data-bits"));
                            StopBits sb = StopBits.value((String)node.valueOf("@stop-bits"));
                            pr = Parity.valueOf((String)node.valueOf("@parity"));
                            SerialParams params7 = new SerialParams(speed, db, sb, (Parity)pr);
                            conn.putParams(params7);
                            this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                        }
                        this.setBarcodeScannerConfiguration(new DeviceConfiguration<SerialPort>(type, conn));
                    }
                    this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u043e\u0432");
                } else {
                    this.log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u043e\u0439 \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u043e\u0432");
                }
            }
            catch (Exception ex) {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0441\u043a\u0430\u043d\u0435\u0440\u0430 \u0448\u0442\u0440\u0438\u0445-\u043a\u043e\u0434\u0430: " + ex.getMessage()));
            }
            try {
                Element cm;
                StopBits sb;
                DeviceType type5;
                String port3;
                String proto3;
                this.log.info((Object)"*********** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043c\u043e\u0434\u0435\u043c\u0430 *********");
                node = document.selectSingleNode("//modem-system");
                if (node != null) {
                    try {
                        this.pppUse = Boolean.parseBoolean(node.valueOf("@ppp-use"));
                        this.log.info((Object)("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u0430 \u043e\u043f\u0446\u0438\u044f '\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c ppp': " + this.pppUse));
                        this.pppName = node.valueOf("@ppp-name");
                        this.log.info((Object)("\u041f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u0430 \u043e\u043f\u0446\u0438\u044f '\u0438\u043c\u044f ppp-\u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f': " + this.pppName));
                    }
                    catch (Exception ex) {
                        this.pppUse = false;
                        this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u043e\u043f\u0446\u0438\u0438 '\u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c ppp'");
                    }
                } else {
                    this.log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 modem-system");
                }
                node = document.selectSingleNode("//modem-system/modem");
                if (node != null) {
                    proto = node.valueOf("@driver");
                    port = node.valueOf("@port");
                    type = DeviceType.valueOf((String)proto);
                    this.log.info((Object)("\u0422\u0438\u043f \u043c\u043e\u0434\u0435\u043c\u0430 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port));
                    conn = new SerialPort(port);
                    this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                    node = document.selectSingleNode("//serial-ports/port[@name=//modem-system/modem/@port]");
                    if (node != null) {
                        this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                        int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                        db = DataBits.value((String)node.valueOf("@data-bits"));
                        StopBits sb3 = StopBits.value((String)node.valueOf("@stop-bits"));
                        pr = Parity.valueOf((String)node.valueOf("@parity"));
                        SerialParams params8 = new SerialParams(speed, db, sb3, (Parity)pr);
                        conn.putParams(params8);
                        this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                    }
                    this.setModemConfiguration(new DeviceConfiguration<SerialPort>(type, conn));
                    node = document.selectSingleNode("//modem-system/modem/check-balance");
                    if (node != null) {
                        try {
                            this.ussdCheck = Boolean.parseBoolean(node.valueOf("@active"));
                            this.log.info((Object)("\u0417\u0430\u043f\u0440\u0430\u0448\u0438\u0432\u0430\u0442\u044c \u0431\u0430\u043b\u0430\u043d\u0441: " + this.ussdCheck));
                            this.ussdAutoRequest = Boolean.parseBoolean(node.valueOf("@auto-configure"));
                            this.log.info((Object)("\u0410\u0432\u0442\u043e\u043c\u0430\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0435 \u0441\u0442\u0440\u043e\u043a\u0438 USSD-\u0437\u0430\u043f\u0440\u043e\u0441\u0430: " + this.ussdAutoRequest));
                            this.ussdRequest = node.valueOf("@request");
                            this.log.info((Object)("\u0417\u0430\u043f\u0440\u043e\u0441 USSD: " + this.ussdRequest));
                        }
                        catch (Exception ex) {
                            this.ussdCheck = false;
                            this.ussdRequest = null;
                        }
                    }
                    if ((node = document.selectSingleNode("//modem-system/modem/use-software-watchdog")) != null) {
                        try {
                            this.softwareWatchDogUse = Boolean.parseBoolean(node.valueOf("@active"));
                            this.log.info((Object)("\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u043d\u044b\u0439 \u0441\u0442\u043e\u0440\u043e\u0436: " + this.softwareWatchDogUse));
                        }
                        catch (Exception ex) {
                            this.softwareWatchDogUse = false;
                        }
                    }
                    this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043c\u043e\u0434\u0435\u043c\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                } else {
                    this.log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u043e\u0439 \u043c\u043e\u0434\u0435\u043c\u0430");
                }
                try {
                    Node pinpad = document.selectSingleNode("//pinpad");
                    if (pinpad != null) {
                        this.log.info((Object)"*********** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u0438\u043d\u043f\u0430\u0434\u0430 *********");
                        proto3 = pinpad.valueOf("@driver");
                        port3 = pinpad.valueOf("@port");
                        type5 = DeviceType.valueOf((String)proto3);
                        this.log.info((Object)("\u0422\u0438\u043f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type5 + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port3));
                        SerialPort conn5 = new SerialPort(port3);
                        this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                        node = document.selectSingleNode("//serial-ports/port[@name=//pinpad/@port]");
                        if (node != null) {
                            this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                            int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                            DataBits db5 = DataBits.value((String)node.valueOf("@data-bits"));
                            sb = StopBits.value((String)node.valueOf("@stop-bits"));
                            Parity pr5 = Parity.valueOf((String)node.valueOf("@parity"));
                            params = new SerialParams(speed, db5, sb, pr5);
                            conn5.putParams((SerialParams)params);
                            this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                        }
                        this.setPinpadConfiguration(new DeviceConfiguration<SerialPort>(type5, conn5));
                        this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u043f\u0438\u043d\u043f\u0430\u0434\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                    } else {
                        this.log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u043e\u0439 \u043f\u0438\u043d\u043f\u0430\u0434\u0430");
                    }
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043f\u0438\u043d\u043f\u0430\u0434\u0430: ", (Throwable)ex);
                }
                try {
                    Node hopper = document.selectSingleNode("//hopper");
                    if (hopper != null) {
                        this.log.info((Object)"*********** \u041d\u0430\u0447\u0438\u043d\u0430\u044e \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0445\u043e\u043f\u043f\u0435\u0440\u0430 *********");
                        proto3 = hopper.valueOf("@driver");
                        port3 = hopper.valueOf("@port");
                        type5 = DeviceType.valueOf((String)proto3);
                        this.log.info((Object)("\u0422\u0438\u043f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d: " + type5 + " \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u043c\u044b\u0439 \u043f\u043e\u0440\u0442: " + port3));
                        SerialPort conn6 = new SerialPort(port3);
                        this.log.info((Object)"\u041f\u043e\u0440\u0442 \u043f\u0440\u0438\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u0432 \u0441\u0438\u0441\u0442\u0435\u043c\u0435. \u041a\u043b\u0430\u0441\u0441 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441\u043e\u0437\u0434\u0430\u043d.");
                        node = document.selectSingleNode("//serial-ports/port[@name=//pinpad/@port]");
                        if (node != null) {
                            this.log.info((Object)"\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u044b \u0441\u043f\u0435\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u043f\u043e\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043f\u043e\u0440\u0442\u0430");
                            int speed = Integer.parseInt(node.valueOf("@baud-rate"));
                            DataBits db6 = DataBits.value((String)node.valueOf("@data-bits"));
                            sb = StopBits.value((String)node.valueOf("@stop-bits"));
                            Parity pr6 = Parity.valueOf((String)node.valueOf("@parity"));
                            params = new SerialParams(speed, db6, sb, pr6);
                            conn6.putParams((SerialParams)params);
                            this.log.info((Object)"\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u044b \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b");
                        }
                        this.setCoinHopperConfiguration(new DeviceConfiguration<SerialPort>(type5, conn6));
                        this.log.info((Object)"C\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u043e\u0432 \u0445\u043e\u043f\u043f\u0435\u0440\u0430 \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                    } else {
                        this.log.error((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u043e\u0439 \u0445\u043e\u043f\u043f\u0435\u0440\u0430");
                    }
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u0445\u043e\u043f\u043f\u0435\u0440\u0430: ", (Throwable)ex);
                }
                try {
                    cm = root.element("card-module");
                    if (cm != null) {
                        this.log.info((Object)"*********** \u0421\u043e\u0437\u0434\u0430\u044e \u043a\u0430\u0440\u0442\u043e\u0447\u043d\u044b\u0439 \u043c\u043e\u0434\u0443\u043b\u044c *********");
                        this.cardModuleType = cm.attributeValue("type");
                        this.log.info((Object)("\u0422\u0438\u043f: " + this.cardModuleType));
                        this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                    } else {
                        this.log.info((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u043e\u0439 \u043a\u0430\u0440\u0442\u043e\u0447\u043d\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f");
                    }
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043a\u0430\u0440\u0442\u043e\u0447\u043d\u043e\u0433\u043e \u043c\u043e\u0434\u0443\u043b\u044f: ", (Throwable)ex);
                }
                try {
                    cm = root.element("present-module");
                    if (cm != null) {
                        this.log.info((Object)"*********** \u0421\u043e\u0437\u0434\u0430\u044e \u043c\u043e\u0434\u0443\u043b\u044c \u043f\u043e\u0434\u0430\u0440\u043a\u043e\u0432 *********");
                        String type6 = cm.attributeValue("type");
                        Integer cost = Integer.parseInt(cm.attributeValue("cost"));
                        if (cost < 0 || cost > 9900) {
                            throw new Exception("Wrong present cost");
                        }
                        this.presentConfiguration = new PresentConfiguration();
                        this.presentConfiguration.setType(type6);
                        this.presentConfiguration.setOptions(new DispenserOptions(cost.intValue()));
                        if ("NetworkModule".equals(type6)) {
                            Element nm = cm.element("network-module");
                            if (nm == null) {
                                throw new Exception("Module not found");
                            }
                            String tp = nm.attributeValue("type");
                            this.presentConfiguration.setDriver(tp);
                            String host = nm.attributeValue("host");
                            String port4 = nm.attributeValue("port");
                            DispenserNetworkOptions pnc = new DispenserNetworkOptions();
                            pnc.setHost(host);
                            pnc.setPort(port4 != null && port4.matches("^\\d+$") ? Integer.valueOf(Integer.parseInt(port4)) : null);
                            this.presentConfiguration.setNetworkOptions(pnc);
                        }
                        this.log.info((Object)"\u0421\u043e\u0437\u0434\u0430\u043d\u0438\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0435\u043a \u0437\u0430\u043a\u043e\u043d\u0447\u0435\u043d\u043e");
                        break block146;
                    }
                    this.log.info((Object)"\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u0430 \u0441\u0435\u043a\u0446\u0438\u044f \u0441 \u043c\u043e\u0434\u0443\u043b\u044f \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u0440\u0438\u0437\u043e\u0432");
                }
                catch (Exception ex) {
                    this.log.error((Object)"\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u0438 \u043c\u043e\u0434\u0443\u043b\u044f \u0432\u044b\u0434\u0430\u0447\u0438 \u043f\u0440\u0438\u0437\u043e\u0432: ", (Throwable)ex);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u0447\u0442\u0435\u043d\u0438\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438: " + ex.getMessage()));
            }
        }
        this.log.info((Object)"****************** \u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0440\u043e\u0447\u0438\u0442\u0430\u043d\u0430 *******************");
    }

    private String readString(Node node, String def) {
        if (node != null) {
            return node.valueOf("@value");
        }
        return def;
    }

    private int readInt(Node node, int def) {
        if (node != null) {
            return this.readInt(node.valueOf("@value"), def);
        }
        return def;
    }

    private Integer readInt(Element node) {
        String val;
        if (node != null && (val = node.attributeValue("value")) != null && val.matches("^\\d+$")) {
            return Integer.parseInt(val);
        }
        return null;
    }

    private int readInt(String value, int def) {
        if (value == null) {
            return def;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception ex) {
            return def;
        }
    }
}

