/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.app;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import ru.softlogic.system.util.DaemonUtil;
import ru.softlogic.system.util.PathUtils;
import ru.softlogic.update.postproc.Maintenance;

public class UpdateMain {
    private static Logger log = Logger.getLogger((String)"start");

    public static void main(String[] args) throws InterruptedException {
        try {
            File flag;
            DaemonUtil.getUpdateBuild();
            Maintenance maintenance = new Maintenance();
            log.info((Object)"=== Start update ==========================================");
            File src = new File(PathUtils.getAppHome() + File.separator + "update");
            File dst = new File(PathUtils.getAppHome());
            log.info((Object)("Source      : " + src.getAbsolutePath()));
            log.info((Object)("Destination : " + dst.getAbsolutePath()));
            if (src.exists() && src.isDirectory()) {
                try {
                    FileUtils.copyDirectory((File)src, (File)dst);
                    log.info((Object)"Complete, clean update directory");
                    FileUtils.cleanDirectory((File)src);
                    log.info((Object)"Complete, move list.xml to update folder");
                    FileUtils.moveToDirectory((File)PathUtils.getFilePath((String)"list.xml"), (File)src, (boolean)true);
                    File mf = PathUtils.getFilePath((String)"maintenance.rules");
                    if (mf.exists()) {
                        log.info((Object)"Complete, move maintenance.rules to update folder");
                        FileUtils.moveToDirectory((File)mf, (File)src, (boolean)true);
                        log.info((Object)"Copy complete");
                    }
                    DaemonUtil.createExitFlag((String)"_flag_sftupdate_exec");
                    log.info((Object)"Exit flag created");
                }
                catch (IOException ex) {
                    try {
                        DaemonUtil.saveObject((Object)ex, (String)"_update_exception");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    log.error((Object)"An error occurred while updating", (Throwable)ex);
                }
            }
            if ((flag = new File(PathUtils.getAppHome() + File.separator + "updated.ready")).exists()) {
                log.info((Object)("Flag        : " + flag.getAbsolutePath()));
                if (flag.delete()) {
                    log.info((Object)"Flag successfully removed");
                } else {
                    log.info((Object)"An error occurred while removing the flag");
                }
            }
            log.info((Object)"=== Maintenance software ==================================");
            boolean success = maintenance.serve(new File(PathUtils.getAppHome()), new File(PathUtils.getAppHome(), "/update/"));
            if (!success) {
                log.info((Object)"Some files could not be removed");
            }
            log.info((Object)"=== Update finished =======================================");
            System.exit(success ? 0 : 1);
        }
        catch (Throwable tw) {
            log.error((Object)tw, tw);
            try {
                DaemonUtil.saveObject((Object)new Exception(tw), (String)"_update_exception");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.exit(0);
    }
}

