/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.util;

import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.ValidationContext;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.validation.ValidationState;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSTypeDefinition;

public class XSTypeHelper {
    public static boolean isSchemaTypesIdentical(XSTypeDefinition xSTypeDefinition, XSTypeDefinition xSTypeDefinition2) {
        boolean bl = false;
        String string = xSTypeDefinition.getName();
        String string2 = xSTypeDefinition2.getName();
        if ("anyType".equals(string) && "anyType".equals(string2) || "anySimpleType".equals(string) && "anySimpleType".equals(string2)) {
            bl = true;
        }
        if (!bl && XSTypeHelper.isUriEqual(xSTypeDefinition.getNamespace(), xSTypeDefinition2.getNamespace()) && (string == null && string2 == null || string != null && string.equals(string2) && XSTypeHelper.isSchemaTypesIdentical(xSTypeDefinition.getBaseType(), xSTypeDefinition2.getBaseType()))) {
            bl = true;
        }
        return bl;
    }

    public static boolean isUriEqual(String string, String string2) {
        boolean bl = false;
        if (string != null && string2 == null || string == null && string2 != null) {
            bl = false;
        } else if (string == null && string2 == null || string.equals(string2)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isAtomicValueValidForAnUnion(XSObjectList xSObjectList, String string, ValidatedInfo validatedInfo) {
        boolean bl = false;
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            XSSimpleType xSSimpleType = (XSSimpleType)xSObjectList.item(i);
            if (!SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(xSSimpleType.getNamespace()) || !XSTypeHelper.isValueValidForASimpleType(string, xSSimpleType)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean isValueValidForASimpleType(String string, XSSimpleType xSSimpleType) {
        boolean bl = true;
        try {
            ValidatedInfo validatedInfo = new ValidatedInfo();
            ValidationState validationState = new ValidationState();
            xSSimpleType.validate(string, (ValidationContext)validationState, validatedInfo);
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            bl = false;
        }
        return bl;
    }
}

