/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers.override;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.override.OverrideTransformException;
import org.apache.xerces.impl.xs.traversers.override.OverrideTransformer;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;

public final class DOMOverrideImpl
extends OverrideTransformer {
    private final ArrayList fOverrideComponents = new ArrayList();
    private final HashMap[] fOverrideComponentsMap = new HashMap[]{null, new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap(), new HashMap()};
    private Document fOverridenDoc;
    private Element fOverrideElem;
    private boolean hasPerformedTransformations = false;
    private DOMImplementation fDOMImpl;
    private final XSDHandler fSchemaHandler;

    public DOMOverrideImpl(XSDHandler xSDHandler) {
        this.fSchemaHandler = xSDHandler;
        try {
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            this.fDOMImpl = dOMImplementationRegistry.getDOMImplementation("XML 3.0");
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
    }

    public void clearState() {
        this.fOverrideComponents.clear();
        for (int i = 1; i < this.fOverrideComponentsMap.length; ++i) {
            this.fOverrideComponentsMap[i].clear();
        }
        this.fOverridenDoc = null;
        this.fOverrideElem = null;
        this.hasPerformedTransformations = false;
    }

    public Element transform(Element element, Element element2) throws OverrideTransformException {
        this.fOverridenDoc = this.cloneOverridenSchema(element2);
        Element element3 = this.fOverridenDoc.getDocumentElement();
        this.fOverrideElem = element;
        this.fillOverrideElementMap(this.fOverrideElem);
        this.transform(element3, false);
        if (this.hasOverrideTransformations()) {
            this.clearState();
            return element3;
        }
        this.clearState();
        return null;
    }

    public boolean hasOverrideTransformations() {
        return this.hasPerformedTransformations;
    }

    private void transform(Element element, boolean bl) {
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = this.getLocalName(element2);
            if (!string.equals(SchemaSymbols.ELT_ANNOTATION)) {
                Object object;
                if (string.equals(SchemaSymbols.ELT_INCLUDE)) {
                    object = this.fOverrideElem;
                    String string2 = element2.getAttribute(SchemaSymbols.ATT_SCHEMALOCATION);
                    element2 = this.performDOMOverride(element, (Element)object, element2);
                    element2.setAttribute(SchemaSymbols.ATT_SCHEMALOCATION, string2);
                    this.hasPerformedTransformations = true;
                } else if (string.equals(SchemaSymbols.ELT_REDEFINE)) {
                    this.transform(element2, false);
                } else if (string.equals(SchemaSymbols.ELT_OVERRIDE)) {
                    this.transform(element2, true);
                    this.mergeOverride(element2);
                } else {
                    int n;
                    object = DOMUtil.getAttrValue(element2, SchemaSymbols.ATT_NAME);
                    if (((String)object).length() != 0 && (n = this.getOverrideType(string)) != 0) {
                        OverrideElement overrideElement = this.getMatchingOverrideElement(n, (String)object);
                        Element element3 = element2;
                        if (overrideElement != null) {
                            String string3;
                            if (n == 1 && !string.equals(string3 = this.getLocalName(overrideElement.originalElement))) {
                                this.fSchemaHandler.reportSchemaError("src-override-transformation.1", new Object[]{string3, string, object}, overrideElement.originalElement);
                                if (bl) {
                                    overrideElement.overrideCloned = true;
                                }
                            } else {
                                element2 = this.performDOMOverride(element, overrideElement.originalElement, element3);
                                if (!element2.isEqualNode(element3)) {
                                    this.hasPerformedTransformations = true;
                                }
                                if (bl) {
                                    overrideElement.overrideCloned = true;
                                }
                            }
                        }
                    }
                }
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
    }

    private void fillOverrideElementMap(Element element) {
        Element element2 = DOMUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = this.getLocalName(element2);
            if (!string.equals(SchemaSymbols.ELT_ANNOTATION)) {
                int n = this.getOverrideType(string);
                if (n != 0) {
                    this.addOverrideElement(n, element2);
                } else {
                    this.fSchemaHandler.reportSchemaError("s4s-elt-must-match.1", new Object[]{"override", "(annotation | (simpleType | complexType | group | attributeGroup | element | attribute | notation))*", DOMUtil.getLocalName(element2)}, element2);
                }
            }
            element2 = DOMUtil.getNextSiblingElement(element2);
        }
    }

    private void addOverrideElement(int n, Element element) {
        HashMap hashMap = this.fOverrideComponentsMap[n];
        String string = DOMUtil.getAttrValue(element, SchemaSymbols.ATT_NAME);
        if (hashMap.get(string) != null) {
            this.fSchemaHandler.reportSchemaError("sch-props-correct.2", new Object[]{string}, element);
        } else {
            OverrideElement overrideElement = new OverrideElement(n, element, string);
            this.fOverrideComponents.add(overrideElement);
            hashMap.put(string, overrideElement);
        }
    }

    private OverrideElement getMatchingOverrideElement(int n, String string) {
        Iterator iterator = this.fOverrideComponents.iterator();
        while (iterator.hasNext()) {
            OverrideElement overrideElement = (OverrideElement)iterator.next();
            if (overrideElement.componentType != n || !overrideElement.cName.equals(string)) continue;
            return overrideElement;
        }
        return null;
    }

    private int getOverrideType(String string) {
        if (string.equals(SchemaSymbols.ELT_SIMPLETYPE) || string.equals(SchemaSymbols.ELT_COMPLEXTYPE)) {
            return 1;
        }
        if (string.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP)) {
            return 2;
        }
        if (string.equals(SchemaSymbols.ELT_GROUP)) {
            return 3;
        }
        if (string.equals(SchemaSymbols.ELT_ELEMENT)) {
            return 4;
        }
        if (string.equals(SchemaSymbols.ELT_NOTATION)) {
            return 5;
        }
        if (string.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
            return 6;
        }
        return 0;
    }

    private Document cloneOverridenSchema(Element element) {
        Document document = this.fDOMImpl.createDocument(null, null, null);
        Node node = document.importNode(element, true);
        document.setDocumentURI(element.getOwnerDocument().getDocumentURI());
        document.appendChild(node);
        return document;
    }

    private Node getChildClone(Node node) {
        return this.fOverridenDoc.importNode(node, true);
    }

    private void mergeOverride(Element element) {
        Iterator iterator = this.fOverrideComponents.iterator();
        while (iterator.hasNext()) {
            OverrideElement overrideElement = (OverrideElement)iterator.next();
            if (!overrideElement.overrideCloned) {
                element.appendChild(this.getChildClone(overrideElement.originalElement));
                this.hasPerformedTransformations = true;
                continue;
            }
            overrideElement.overrideCloned = false;
        }
    }

    private Element performDOMOverride(Element element, Element element2, Element element3) {
        Element element4 = (Element)this.getChildClone(element2);
        element.replaceChild(element4, element3);
        return element4;
    }

    private String getLocalName(Node node) {
        String string = "";
        string = DOMUtil.getLocalName(node);
        if (string.indexOf(":") > -1) {
            return string.split(":")[1];
        }
        return string;
    }

    private static final class OverrideElement {
        final int componentType;
        final Element originalElement;
        final String cName;
        boolean overrideCloned = false;

        OverrideElement(int n, Element element, String string) {
            this.componentType = n;
            this.originalElement = element;
            this.cName = string;
        }
    }
}

