/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.xerces.impl.xs.AttributePSVImpl;
import org.apache.xerces.impl.xs.ElementPSVImpl;
import org.apache.xerces.impl.xs.ObjectFactory;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.SecuritySupport;
import org.apache.xerces.impl.xs.XMLAssertPsychopathImpl;
import org.apache.xerces.impl.xs.XMLSchemaValidator;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.assertion.XMLAssertHandler;
import org.apache.xerces.impl.xs.assertion.XSAssert;
import org.apache.xerces.impl.xs.assertion.XSAssertImpl;
import org.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSMultiValueFacet;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;

public class XSDAssertionValidator {
    XMLSchemaValidator xmlSchemaValidator = null;
    XMLAssertHandler fAssertionProcessor = null;

    public XSDAssertionValidator(XMLSchemaValidator xMLSchemaValidator) {
        this.xmlSchemaValidator = xMLSchemaValidator;
    }

    public void characterDataHandler(XMLString xMLString) {
        if (this.fAssertionProcessor != null) {
            this.fAssertionProcessor.characters(xMLString);
        }
    }

    public void handleStartElement(QName qName, XMLAttributes xMLAttributes) {
        Object object;
        List list = this.getAssertsForEvaluation(qName, xMLAttributes);
        if (list != null && this.fAssertionProcessor == null) {
            Cloneable cloneable;
            object = null;
            if (list instanceof XSObjectList) {
                object = ((XSAssertImpl)((XSObjectList)list).item(0)).getXPath2NamespaceContext();
            } else {
                cloneable = (Vector)list;
                object = ((XSAssertImpl)((Vector)cloneable).get(0)).getXPath2NamespaceContext();
            }
            cloneable = new HashMap();
            cloneable.put("XPATH2_NS_CONTEXT", object);
            this.initializeAssertProcessor((Map)((Object)cloneable));
        }
        if (this.fAssertionProcessor != null) {
            object = new AugmentationsImpl();
            ((AugmentationsImpl)object).putItem("ASSERT", list);
            this.fAssertionProcessor.startElement(qName, xMLAttributes, (Augmentations)object);
        }
    }

    public void handleEndElement(QName qName, XSElementDecl xSElementDecl, XSTypeDefinition xSTypeDefinition, XSNotationDecl xSNotationDecl, XSGrammarBucket xSGrammarBucket, boolean bl) {
        if (this.fAssertionProcessor != null) {
            try {
                ElementPSVImpl elementPSVImpl = new ElementPSVImpl();
                elementPSVImpl.fDeclaration = xSElementDecl;
                elementPSVImpl.fTypeDecl = xSTypeDefinition;
                elementPSVImpl.fNotation = xSNotationDecl;
                elementPSVImpl.fGrammars = xSGrammarBucket.getGrammars();
                AugmentationsImpl augmentationsImpl = new AugmentationsImpl();
                augmentationsImpl.putItem("ELEMENT_PSVI", elementPSVImpl);
                augmentationsImpl.putItem("ATOMIC_VALUE_VALIDITY", bl);
                this.fAssertionProcessor.endElement(qName, augmentationsImpl);
            }
            catch (Exception exception) {
                throw new XNIException(exception.getMessage(), exception);
            }
        }
    }

    private List getAssertsForEvaluation(QName qName, XMLAttributes xMLAttributes) {
        XSTypeDefinition xSTypeDefinition = this.xmlSchemaValidator.fCurrentPSVI.getTypeDefinition();
        List list = null;
        if (xSTypeDefinition.getTypeCategory() == 15) {
            XSObjectListImpl xSObjectListImpl = this.getAssertsFromComplexType(xSTypeDefinition, xMLAttributes);
            if (xSObjectListImpl.size() > 0) {
                list = xSObjectListImpl;
            }
        } else if (xSTypeDefinition.getTypeCategory() == 16) {
            list = this.getAssertsFromSimpleType(xSTypeDefinition);
        }
        return list;
    }

    private XSObjectListImpl getAssertsFromComplexType(XSTypeDefinition xSTypeDefinition, XMLAttributes xMLAttributes) {
        int n;
        XSObjectList xSObjectList;
        XSSimpleTypeDefinition xSSimpleTypeDefinition;
        XSObjectListImpl xSObjectListImpl = new XSObjectListImpl();
        XSComplexTypeDefinition xSComplexTypeDefinition = (XSComplexTypeDefinition)xSTypeDefinition;
        XSObjectList xSObjectList2 = xSComplexTypeDefinition.getAssertions();
        if (xSObjectList2.getLength() > 0) {
            for (int i = 0; i < xSObjectList2.getLength(); ++i) {
                xSObjectListImpl.addXSObject((XSAssert)xSObjectList2.get(i));
            }
        }
        if ((xSSimpleTypeDefinition = xSComplexTypeDefinition.getSimpleType()) != null) {
            xSObjectList = xSSimpleTypeDefinition.getMultiValueFacets();
            for (n = 0; n < xSObjectList.getLength(); ++n) {
                XSMultiValueFacet xSMultiValueFacet = (XSMultiValueFacet)xSObjectList.item(n);
                if (xSMultiValueFacet.getFacetKind() != 16384) continue;
                Vector vector = xSMultiValueFacet.getAsserts();
                for (int i = 0; i < vector.size(); ++i) {
                    XSAssert xSAssert = (XSAssert)vector.get(i);
                    xSObjectListImpl.addXSObject(xSAssert);
                }
            }
        }
        xSObjectList = this.getAssertsFromAttributes(xMLAttributes);
        for (n = 0; n < ((XSObjectListImpl)xSObjectList).getLength(); ++n) {
            xSObjectListImpl.addXSObject(((XSObjectListImpl)xSObjectList).item(n));
        }
        return xSObjectListImpl;
    }

    private XSObjectListImpl getAssertsFromAttributes(XMLAttributes xMLAttributes) {
        XSObjectListImpl xSObjectListImpl = new XSObjectListImpl();
        block0: for (int i = 0; i < xMLAttributes.getLength(); ++i) {
            Augmentations augmentations = xMLAttributes.getAugmentations(i);
            AttributePSVImpl attributePSVImpl = (AttributePSVImpl)augmentations.getItem("ATTRIBUTE_PSVI");
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)attributePSVImpl.getTypeDefinition();
            if (xSSimpleTypeDefinition == null) continue;
            XSObjectList xSObjectList = xSSimpleTypeDefinition.getMultiValueFacets();
            short s = 0;
            if (xSObjectList.getLength() == 0 && xSSimpleTypeDefinition.getItemType() != null) {
                s = 2;
                xSObjectList = (XSObjectListImpl)xSSimpleTypeDefinition.getItemType().getMultiValueFacets();
            } else if (xSSimpleTypeDefinition.getVariety() == 3) {
                s = 3;
                XSAssertImpl xSAssertImpl = this.getFirstAssertFromUnionMemberTypes(xSSimpleTypeDefinition.getMemberTypes());
                if (xSAssertImpl != null) {
                    xSAssertImpl.setTypeDefinition(xSSimpleTypeDefinition);
                    xSAssertImpl.setVariety(s);
                    xSAssertImpl.setAttrName(xMLAttributes.getLocalName(i));
                    xSAssertImpl.setAttrValue(xMLAttributes.getValue(i));
                    xSObjectListImpl.addXSObject(xSAssertImpl);
                }
            }
            for (int j = 0; j < xSObjectList.getLength(); ++j) {
                XSMultiValueFacet xSMultiValueFacet = (XSMultiValueFacet)xSObjectList.item(j);
                if (xSMultiValueFacet.getFacetKind() != 16384) continue;
                Vector vector = xSMultiValueFacet.getAsserts();
                for (int k = 0; k < vector.size(); ++k) {
                    XSAssertImpl xSAssertImpl = (XSAssertImpl)vector.elementAt(k);
                    xSAssertImpl.setAttrName(xMLAttributes.getLocalName(i));
                    xSAssertImpl.setAttrValue(xMLAttributes.getValue(i));
                    xSAssertImpl.setVariety(s);
                    xSObjectListImpl.addXSObject(xSAssertImpl);
                }
                continue block0;
            }
        }
        return xSObjectListImpl;
    }

    private List getAssertsFromSimpleType(XSTypeDefinition xSTypeDefinition) {
        XSAssertImpl xSAssertImpl;
        Vector<XSAssertImpl> vector = null;
        XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSTypeDefinition;
        XSObjectListImpl xSObjectListImpl = (XSObjectListImpl)xSSimpleTypeDefinition.getMultiValueFacets();
        if (xSObjectListImpl.getLength() == 0 && xSSimpleTypeDefinition.getItemType() != null) {
            xSObjectListImpl = (XSObjectListImpl)xSSimpleTypeDefinition.getItemType().getMultiValueFacets();
        } else if (xSSimpleTypeDefinition.getVariety() == 3 && (xSAssertImpl = this.getFirstAssertFromUnionMemberTypes(xSSimpleTypeDefinition.getMemberTypes())) != null) {
            vector = new Vector<XSAssertImpl>();
            vector.add(xSAssertImpl);
        }
        for (int i = 0; i < xSObjectListImpl.getLength(); ++i) {
            XSMultiValueFacet xSMultiValueFacet = (XSMultiValueFacet)xSObjectListImpl.item(i);
            if (xSMultiValueFacet.getFacetKind() != 16384) continue;
            if (vector == null) {
                vector = new Vector();
            }
            vector.addAll(xSMultiValueFacet.getAsserts());
        }
        return vector;
    }

    private XSAssertImpl getFirstAssertFromUnionMemberTypes(XSObjectList xSObjectList) {
        XSAssertImpl xSAssertImpl = null;
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            XSSimpleTypeDefinition xSSimpleTypeDefinition = (XSSimpleTypeDefinition)xSObjectList.item(i);
            if (SchemaSymbols.URI_SCHEMAFORSCHEMA.equals(xSSimpleTypeDefinition.getNamespace())) continue;
            XSObjectList xSObjectList2 = xSSimpleTypeDefinition.getMultiValueFacets();
            for (int j = 0; j < xSObjectList2.getLength(); ++j) {
                XSMultiValueFacet xSMultiValueFacet = (XSMultiValueFacet)xSObjectList2.item(j);
                if (xSMultiValueFacet.getFacetKind() != 16384) continue;
                Vector vector = xSMultiValueFacet.getAsserts();
                xSAssertImpl = (XSAssertImpl)vector.get(0);
                return xSAssertImpl;
            }
        }
        return xSAssertImpl;
    }

    private void initializeAssertProcessor(Map map) {
        String string;
        try {
            string = SecuritySupport.getSystemProperty("org.apache.xerces.assertProcessor");
        }
        catch (SecurityException securityException) {
            string = null;
        }
        if (string == null || string.length() == 0) {
            this.fAssertionProcessor = new XMLAssertPsychopathImpl(map);
        } else {
            try {
                ClassLoader classLoader = ObjectFactory.findClassLoader();
                Class clazz = ObjectFactory.findProviderClass(string, classLoader, true);
                this.fAssertionProcessor = (XMLAssertHandler)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new XNIException(classNotFoundException.getMessage(), classNotFoundException);
            }
            catch (InstantiationException instantiationException) {
                throw new XNIException(instantiationException.getMessage(), instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new XNIException(illegalAccessException.getMessage(), illegalAccessException);
            }
        }
        this.fAssertionProcessor.setProperty("http://apache.org/xml/properties/assert/validator", this.xmlSchemaValidator);
    }
}

