/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath;

import java.io.Reader;
import org.apache.xerces.impl.xpath.AttrNode;
import org.apache.xerces.impl.xpath.CastNode;
import org.apache.xerces.impl.xpath.CompNode;
import org.apache.xerces.impl.xpath.ConjunctionNode;
import org.apache.xerces.impl.xpath.FunctionNode;
import org.apache.xerces.impl.xpath.LiteralNode;
import org.apache.xerces.impl.xpath.SimpleCharStream;
import org.apache.xerces.impl.xpath.Token;
import org.apache.xerces.impl.xpath.XPath20ParserTokenManager;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xpath.XPathSyntaxTreeNode;

public class XPath20Parser {
    public static final int EOF = 0;
    public static final int KEYWORD_AND = 2;
    public static final int KEYWORD_OR = 3;
    public static final int KEYWORD_CAST = 4;
    public static final int KEYWORD_AS = 5;
    public static final int SYMBOL_COLON = 6;
    public static final int SYMBOL_AT = 7;
    public static final int SYMBOL_QUESTION = 8;
    public static final int OPEN_PARAN = 9;
    public static final int CLOSE_PARAN = 10;
    public static final int SYMBOL_EQ = 11;
    public static final int SYMBOL_NE = 12;
    public static final int SYMBOL_LT = 13;
    public static final int SYMBOL_GT = 14;
    public static final int SYMBOL_LE = 15;
    public static final int SYMBOL_GE = 16;
    public static final int NUMERIC_LITERAL = 17;
    public static final int DIGITS = 18;
    public static final int NCNAME = 19;
    public static final int NCNAME_START_CHAR = 20;
    public static final int NCNAME_CHAR = 21;
    public static final int ESCAPE_QUOTE = 22;
    public static final int ESCAPE_APOS = 23;
    public static final int STRING_LITERAL = 24;
    public static final int DEFAULT = 0;
    String[] tokenImage = new String[]{"<EOF>", "\" \"", "\"and\"", "\"or\"", "\"cast\"", "\"as\"", "\":\"", "\"@\"", "\"?\"", "\"(\"", "\")\"", "\"=\"", "\"!=\"", "\"<\"", "\">\"", "\"<=\"", "\">=\"", "<NUMERIC_LITERAL>", "<DIGITS>", "<NCNAME>", "<NCNAME_START_CHAR>", "<NCNAME_CHAR>", "\"\\\"\\\"\"", "\"\\'\\'\"", "<STRING_LITERAL>", "\"\\n\""};
    public XPath20ParserTokenManager tokenSource;
    SimpleCharStream inputStream;
    public Token token;
    public Token nextToken;
    private int nextTokenIndex;
    private int gen;
    private final int[] array1 = new int[10];

    public XPathSyntaxTreeNode parseExpression() throws XPathException {
        return this.Test();
    }

    private XPathSyntaxTreeNode Test() throws XPathException {
        XPathSyntaxTreeNode xPathSyntaxTreeNode = this.OrExpr();
        this.consumeToken(25);
        return xPathSyntaxTreeNode;
    }

    private XPathSyntaxTreeNode OrExpr() throws XPathException {
        XPathSyntaxTreeNode xPathSyntaxTreeNode;
        block3: {
            xPathSyntaxTreeNode = this.AndExpr();
            switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
                case 3: {
                    break;
                }
                default: {
                    this.array1[0] = this.gen;
                    break block3;
                }
            }
            this.consumeToken(3);
            XPathSyntaxTreeNode xPathSyntaxTreeNode2 = this.AndExpr();
            return new ConjunctionNode(0, xPathSyntaxTreeNode, xPathSyntaxTreeNode2);
        }
        return xPathSyntaxTreeNode;
    }

    private XPathSyntaxTreeNode AndExpr() throws XPathException {
        XPathSyntaxTreeNode xPathSyntaxTreeNode;
        block3: {
            xPathSyntaxTreeNode = this.BooleanExpr();
            switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
                case 2: {
                    break;
                }
                default: {
                    this.array1[1] = this.gen;
                    break block3;
                }
            }
            this.consumeToken(2);
            XPathSyntaxTreeNode xPathSyntaxTreeNode2 = this.BooleanExpr();
            return new ConjunctionNode(1, xPathSyntaxTreeNode, xPathSyntaxTreeNode2);
        }
        return xPathSyntaxTreeNode;
    }

    private XPathSyntaxTreeNode BooleanExpr() throws XPathException {
        switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
            case 9: {
                this.consumeToken(9);
                XPathSyntaxTreeNode xPathSyntaxTreeNode = this.OrExpr();
                this.consumeToken(10);
                return xPathSyntaxTreeNode;
            }
            case 19: {
                String string = this.QName();
                this.consumeToken(9);
                XPathSyntaxTreeNode xPathSyntaxTreeNode = this.OrExpr();
                this.consumeToken(10);
                return new FunctionNode(string, xPathSyntaxTreeNode);
            }
            case 7: 
            case 17: 
            case 24: {
                XPathSyntaxTreeNode xPathSyntaxTreeNode = this.CastExpr();
                switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: {
                        int n = this.Comparator();
                        XPathSyntaxTreeNode xPathSyntaxTreeNode2 = this.CastExpr();
                        return new CompNode(n, xPathSyntaxTreeNode, xPathSyntaxTreeNode2);
                    }
                }
                this.array1[2] = this.gen;
                return xPathSyntaxTreeNode;
            }
        }
        this.array1[3] = this.gen;
        this.consumeToken(-1);
        throw new XPathException("c-general-xpath");
    }

    private String QName() throws XPathException {
        Token token = this.consumeToken(19);
        String string = token.image;
        switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
            case 6: {
                this.consumeToken(6);
                Token token2 = this.consumeToken(19);
                string = string + ":" + token2.image;
                break;
            }
            default: {
                this.array1[4] = this.gen;
            }
        }
        return string;
    }

    private int Comparator() throws XPathException {
        switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
            case 11: {
                this.consumeToken(11);
                return 0;
            }
            case 12: {
                this.consumeToken(12);
                return 1;
            }
            case 14: {
                this.consumeToken(14);
                return 3;
            }
            case 13: {
                this.consumeToken(13);
                return 2;
            }
            case 16: {
                this.consumeToken(16);
                return 5;
            }
            case 15: {
                this.consumeToken(15);
                return 4;
            }
        }
        this.array1[5] = this.gen;
        this.consumeToken(-1);
        throw new XPathException("c-general-xpath");
    }

    private XPathSyntaxTreeNode CastExpr() throws XPathException {
        XPathSyntaxTreeNode xPathSyntaxTreeNode = this.SimpleValue();
        switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
            case 4: {
                this.consumeToken(4);
                this.consumeToken(5);
                String string = this.QName();
                switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
                    case 8: {
                        this.consumeToken(8);
                        break;
                    }
                    default: {
                        this.array1[6] = this.gen;
                    }
                }
                return new CastNode(xPathSyntaxTreeNode, string);
            }
        }
        this.array1[7] = this.gen;
        return xPathSyntaxTreeNode;
    }

    private XPathSyntaxTreeNode SimpleValue() throws XPathException {
        switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
            case 7: {
                XPathSyntaxTreeNode xPathSyntaxTreeNode = this.AttrName();
                return xPathSyntaxTreeNode;
            }
            case 17: 
            case 24: {
                XPathSyntaxTreeNode xPathSyntaxTreeNode = this.Literal();
                return xPathSyntaxTreeNode;
            }
        }
        this.array1[8] = this.gen;
        this.consumeToken(-1);
        throw new XPathException("c-general-xpath");
    }

    private XPathSyntaxTreeNode AttrName() throws XPathException {
        this.consumeToken(7);
        String string = this.NameTest();
        return new AttrNode(string);
    }

    private XPathSyntaxTreeNode Literal() throws XPathException {
        switch (this.nextTokenIndex == -1 ? this.nextToken() : this.nextTokenIndex) {
            case 17: {
                Token token = this.consumeToken(17);
                return new LiteralNode(token.image, true);
            }
            case 24: {
                Token token = this.consumeToken(24);
                return new LiteralNode(token.image.substring(1, token.image.length() - 1), false);
            }
        }
        this.array1[9] = this.gen;
        this.consumeToken(-1);
        throw new XPathException("c-general-xpath");
    }

    private String NameTest() throws XPathException {
        String string = this.QName();
        return string;
    }

    public XPath20Parser(Reader reader) {
        this.inputStream = new SimpleCharStream(reader, 1, 1);
        this.tokenSource = new XPath20ParserTokenManager(this.inputStream);
        this.token = new Token();
        this.nextTokenIndex = -1;
        this.gen = 0;
        for (int i = 0; i < 10; ++i) {
            this.array1[i] = -1;
        }
    }

    private Token consumeToken(int n) throws XPathException {
        Token token = this.token;
        this.token = token.next != null ? this.token.next : (this.token.next = this.tokenSource.getNextToken());
        this.nextTokenIndex = -1;
        if (this.token.kind == n) {
            ++this.gen;
            return this.token;
        }
        this.token = token;
        throw new XPathException("c-general-xpath");
    }

    private int nextToken() throws XPathException {
        this.nextToken = this.token.next;
        if (this.nextToken == null) {
            this.token.next = this.tokenSource.getNextToken();
            this.nextTokenIndex = this.token.next.kind;
            return this.nextTokenIndex;
        }
        this.nextTokenIndex = this.nextToken.kind;
        return this.nextTokenIndex;
    }
}

