/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xpath;

import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.apache.xerces.impl.xpath.XPathException;
import org.apache.xerces.impl.xpath.XPathSyntaxTreeNode;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;

class CastNode
extends XPathSyntaxTreeNode {
    private String castedType;
    private XPathSyntaxTreeNode child;

    public CastNode(XPathSyntaxTreeNode xPathSyntaxTreeNode, String string) {
        this.child = xPathSyntaxTreeNode;
        this.castedType = string;
    }

    public boolean evaluate(QName qName, XMLAttributes xMLAttributes) throws Exception {
        Object object = this.getValue(xMLAttributes);
        XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)dvFactory.getBuiltInType(this.getTypeName());
        if (xSSimpleTypeDecl.getNumeric()) {
            return object != null && 0.0 != (Double)object;
        }
        return object != null;
    }

    public Object getValue(XMLAttributes xMLAttributes) throws Exception {
        Object object;
        XSSimpleType xSSimpleType = dvFactory.getBuiltInType(this.getTypeName());
        if (xSSimpleType == null) {
            throw new XPathException("Casted type is not a built-in type");
        }
        if (this.child.getType() == 2) {
            String string = this.child.getValue(xMLAttributes).toString();
            object = xSSimpleType.validate(string, null, null);
        } else {
            object = xSSimpleType.validate(this.child.getStringValue(), null, null);
        }
        if (xSSimpleType.getNumeric()) {
            object = dvFactory.getBuiltInType("double").validate(object, null, null);
        }
        return object;
    }

    public String getTypeName() {
        String string = this.castedType;
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public int getType() {
        String string = this.getTypeName();
        XSSimpleTypeDecl xSSimpleTypeDecl = (XSSimpleTypeDecl)dvFactory.getBuiltInType(string);
        if (xSSimpleTypeDecl.getNumeric()) {
            return 0;
        }
        if (string.equals("string")) {
            return 1;
        }
        return 3;
    }
}

