/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.schemas;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXParseException;
import ru.softlogic.schemas.ClasspathResourceResolver;
import ru.softlogic.schemas.SchemasErrorHandler;
import ru.softlogic.schemas.Utils;

public final class XsdValidator {
    public static final String FORMS = "forms";
    public static final String SCENARIO = "scenario";
    public static final String UNKNOWN = "unknown";
    private static final String XML_SCHEMA_11 = "http://www.w3.org/XML/XMLSchema/v1.1";
    private static final String XSD_SCANARIO_PATH = "/ru/softlogic/schemas/adv/scenario.xsd";
    private static final String XSD_FORM_PATH = "/ru/softlogic/schemas/uni/forms.xsd";
    private static volatile DocumentBuilder parser;
    private static volatile SchemaFactory sf;
    private static volatile Validator xsdForm;
    private static volatile Validator xsdScen;

    private XsdValidator() {
    }

    public static List<SAXParseException> validateXml(File file, boolean isSetNameSpace) throws FileNotFoundException {
        return XsdValidator.validate(new FileInputStream(file), isSetNameSpace);
    }

    public static List<SAXParseException> validateXml(String form, boolean isSetNameSpace) {
        return XsdValidator.validate(new ByteArrayInputStream(form.getBytes()), isSetNameSpace);
    }

    public static List<SAXParseException> validateXml(URL url, boolean isSetNameSpace) throws IOException {
        return XsdValidator.validate(url.openStream(), isSetNameSpace);
    }

    public static String getRootElement(File file) throws FileNotFoundException {
        return XsdValidator.getRootElement(new FileInputStream(file));
    }

    public static String getRootElement(String form) {
        return XsdValidator.getRootElement(new ByteArrayInputStream(form.getBytes()));
    }

    public static String getRootElement(URL url) throws IOException {
        return XsdValidator.getRootElement(url.openStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRootElement(InputStream stream) {
        try {
            Document document = XsdValidator.getParser().parse(stream);
            Element root = document.getDocumentElement();
            String string = root.getLocalName();
            return string;
        }
        catch (Exception ex) {
            String string = null;
            return string;
        }
        finally {
            Utils.closeStream(stream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<SAXParseException> validate(InputStream stream, boolean isSetNameSpace) {
        ArrayList<SAXParseException> exceptions = new ArrayList<SAXParseException>();
        try {
            Document document = XsdValidator.getParser().parse(stream);
            Element root = document.getDocumentElement();
            Validator validator = XsdValidator.getSchema(root.getLocalName());
            if (validator != null) {
                validator.setErrorHandler(new SchemasErrorHandler(exceptions));
                if (isSetNameSpace) {
                    validator.validate(new StreamSource(Utils.nodeToInputStream(document)));
                } else {
                    String strDoc = Utils.toString(root);
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(strDoc.getBytes());
                    validator.validate(new StreamSource(inputStream));
                }
            } else {
                exceptions.add(new SAXParseException("This type of document is not supported", null));
            }
        }
        catch (Exception ex) {
            exceptions.add(new SAXParseException(ex.getMessage(), null));
        }
        finally {
            Utils.closeStream(stream);
        }
        return exceptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DocumentBuilder getParser() throws ParserConfigurationException {
        if (parser != null) return parser;
        Class<XsdValidator> clazz = XsdValidator.class;
        synchronized (XsdValidator.class) {
            if (parser != null) return parser;
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setNamespaceAware(true);
            builderFactory.setXIncludeAware(true);
            builderFactory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            parser = builderFactory.newDocumentBuilder();
            // ** MonitorExit[var0] (shouldn't be in output)
            return parser;
        }
    }

    private static Validator getSchema(String type) {
        try {
            Class<XsdValidator> cls = XsdValidator.class;
            if (FORMS.equals(type)) {
                if (xsdForm == null) {
                    Schema xsd = XsdValidator.getSchemaFactory().newSchema(new StreamSource(cls.getResourceAsStream(XSD_FORM_PATH)));
                    xsdForm = xsd.newValidator();
                }
                return xsdForm;
            }
            if (SCENARIO.equals(type)) {
                if (xsdScen == null) {
                    Schema xsd = XsdValidator.getSchemaFactory().newSchema(new StreamSource(cls.getResourceAsStream(XSD_SCANARIO_PATH)));
                    xsdScen = xsd.newValidator();
                }
                return xsdScen;
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static SchemaFactory getSchemaFactory() {
        if (sf != null) return sf;
        Class<XsdValidator> clazz = XsdValidator.class;
        synchronized (XsdValidator.class) {
            if (sf != null) return sf;
            SchemaFactory factory = SchemaFactory.newInstance(XML_SCHEMA_11);
            factory.setResourceResolver(new ClasspathResourceResolver());
            sf = factory;
            // ** MonitorExit[var0] (shouldn't be in output)
            return sf;
        }
    }
}

