/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.network;

public class Ping {
    private Ping() {
    }

    public static boolean isAlive(String host) {
        if (host == null || host.isEmpty()) {
            return false;
        }
        try {
            String cmdLine = null;
            String osName = System.getProperty("os.name");
            if ("Linux".equals(osName)) {
                cmdLine = "ping -c 1 ";
            } else if (osName.toLowerCase().contains("windows")) {
                cmdLine = "ping -n 1 ";
            }
            if (cmdLine != null) {
                Process p = Runtime.getRuntime().exec(cmdLine + host);
                int status = p.waitFor();
                return status == 0;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static boolean isNetworkAlive() {
        String[] hosts;
        for (String host : hosts = new String[]{"yandex.ru", "google.com", "rambler.ru"}) {
            if (!Ping.isAlive(host)) continue;
            return true;
        }
        return false;
    }
}

