/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.hwd;

import java.util.zip.CRC32;
import ru.softlogic.system.util.OsDetector;
import ru.softlogic.system.util.hwd.LinuxSerialExtractor;
import ru.softlogic.system.util.hwd.SerialExtractor;
import ru.softlogic.system.util.hwd.WindowsSerialExtractor;

public class SerialExtractorApi
implements SerialExtractor {
    private static final SerialExtractorApi INSTANCE = new SerialExtractorApi();
    private String hddSerial;
    private String processorName;
    private SerialExtractor extractor;

    private SerialExtractorApi() {
        switch (OsDetector.current()) {
            case 2: {
                this.extractor = new WindowsSerialExtractor();
                break;
            }
            case 1: {
                this.extractor = new LinuxSerialExtractor();
            }
        }
    }

    public static SerialExtractorApi getInstance() {
        return INSTANCE;
    }

    @Override
    public String getHddSerial() {
        if (this.hddSerial == null) {
            this.hddSerial = this.extractor.getHddSerial();
        }
        return this.hddSerial;
    }

    @Override
    public String getProcessorName() {
        if (this.processorName == null) {
            this.processorName = this.extractor.getProcessorName();
        }
        return this.processorName;
    }

    public long getConfigurationId() {
        String data = this.getHddSerial() + ";" + this.getProcessorName();
        if (";".equals(data)) {
            return 0L;
        }
        CRC32 crc = new CRC32();
        crc.update(data.getBytes());
        return crc.getValue();
    }
}

