/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util.hwd;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import ru.softlogic.system.util.hwd.SerialExtractor;

public class LinuxSerialExtractor
implements SerialExtractor {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getHddSerial() {
        HashMap<String, String> mounts = new HashMap<String, String>();
        try (BufferedReader br = new BufferedReader(new FileReader("/etc/mtab"));){
            int pos;
            String data;
            while ((data = br.readLine()) != null) {
                String[] strs = data.split(" |  ");
                if (strs.length < 2 || !strs[0].startsWith("/")) continue;
                mounts.put(strs[1], strs[0]);
            }
            String drive = null;
            if (mounts.get("/home") != null) {
                drive = (String)mounts.get("/home");
            } else if (mounts.get("/") != null) {
                drive = (String)mounts.get("/");
            }
            if (drive == null) return "";
            for (pos = drive.length() - 1; pos > 0 && Character.isDigit(drive.charAt(pos)); --pos) {
            }
            String serial = (drive = drive.substring(0, pos + 1)).startsWith("/dev/h") ? this.getIdeSerialNative(drive) : this.getScsiSerialNative(drive);
            if (serial != null) {
                serial = serial.trim();
            }
            String string = serial;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getProcessorName() {
        try (BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));){
            String data;
            while ((data = br.readLine()) != null) {
                String[] strs;
                if (!data.startsWith("model name") || (strs = data.split(":")).length != 2) continue;
                String string = strs[1].trim();
                return string;
            }
            String string = "";
            return string;
        }
        catch (IOException ex) {
            return "";
        }
    }

    private native String getIdeSerialNative(String var1);

    private native String getScsiSerialNative(String var1);

    static {
        String archDataModel = System.getProperty("sun.arch.data.model");
        String os = System.getProperty("os.name");
        System.load(System.getProperty("java.library.path") + File.separator + archDataModel + File.separator + "hwdlogic.so");
    }
}

