/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.log4j.Logger;

public class ProcessExecutor {
    private final ExecutorService executor = Executors.newFixedThreadPool(3);
    private final Logger log = Logger.getLogger((String)"app");

    public ProcessExecutor() {
        this.log.info((Object)"Start process executor");
    }

    public int executeProcess(Process proc, int timeout) throws InterruptedException, ExecutionException, TimeoutException {
        if (proc == null) {
            throw new NullPointerException();
        }
        LocalProcessExecutor pe = new LocalProcessExecutor(proc);
        Future<Integer> ft = this.executor.submit(pe);
        return ft.get(timeout, TimeUnit.SECONDS);
    }

    public int executeProcess(String proc, int timeout) throws InterruptedException, ExecutionException, TimeoutException, IOException {
        if (proc == null) {
            throw new NullPointerException();
        }
        return this.executeProcess(Runtime.getRuntime().exec(proc), timeout);
    }

    private class LocalProcessExecutor
    implements Callable<Integer> {
        private Process process;

        public LocalProcessExecutor(Process process) {
            if (process == null) {
                throw new IllegalArgumentException("\u041d\u0443\u0436\u0434\u0430\u044e\u0441\u044c \u0432 Process");
            }
            this.process = process;
        }

        @Override
        public Integer call() throws Exception {
            ProcessExecutor.this.log.info((Object)("=== Execute process " + this.process + " ==="));
            this.process.waitFor();
            this.readStream("err", this.process.getErrorStream());
            this.readStream("inp", this.process.getInputStream());
            return this.process.exitValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void readStream(String id, InputStream stream) {
            BufferedReader br = null;
            try {
                String str;
                br = new BufferedReader(new InputStreamReader(stream));
                ProcessExecutor.this.log.error((Object)("===>>" + id + "===================="));
                while ((str = br.readLine()) != null) {
                    ProcessExecutor.this.log.error((Object)str);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

