/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;

public class PathUtils {
    public static final String ROOT = "/";
    public static final String APP_EXT = "/ext/";
    public static final String APP_LIB = "/lib/";
    public static final String APP_JNI = "/jni/";
    public static final String CONF = "/conf.xml";
    public static final String DATA = "/data/";
    public static final String DATA_SCREENSHOT = "/data/screenshot/";
    public static final String DATA_CASHIN = "/data/cash-in/";
    public static final String DATA_NETWORK = "/data/network/";
    public static final String DATA_SEQUENCE = "/data/sequence/";
    public static final String DATA_KKM = "/data/kkm/";
    public static final String DATA_FLAGS = "/data/flags/";
    public static final String DATA_DISP_BILL = "/data/disp/bill/";
    public static final String DATA_DISP_COIN = "/data/disp/coin/";
    public static final String DATA_SAVE = "/data/save/";
    public static final String BIN = "/bin/";
    public static final String MODULE = "/res/module/";
    public static final String MODULE_I18N = "/res/module/i18n";
    public static final String MODULE_INP = "/res/module/input/";
    public static final String MODULE_INP_UNI = "/res/module/input/universal/";
    public static final String MODULE_INP_ADV = "/res/module/input/advanced/";
    public static final String MODULE_INP_MOBILE = "/res/module/input/mobile/";
    public static final String MODULE_INP_SITE = "/res/module/input/site/";
    public static final String MODULE_DATA_SOURCE = "/res/module/input/ds/";
    public static final String MODULE_ENCODE_MAP = "/res/module/input/encode/";
    public static final String MODULE_UTILITY = "/res/module/utility/";
    public static final String MODULE_PAYOUT = "/res/module/payout/";
    public static final String MODULE_KEEPER = "/res/module/keeper/";
    public static final String MODULE_CARD = "/res/module/input/card/";
    public static final String MODULE_DONATE = "/res/module/donate/";
    public static final String MODULE_MENU = "/res/module/menu/";
    public static final String MODULE_MENU_OFFER = "/res/module/menu/offer{0}.html";
    public static final String MODULE_MENU_HELP = "/res/module/menu/help{0}.html";
    public static final String RESOURCES = "/res/";
    public static final String RESOURCES_DMI = "/res/dmi/";
    public static final String RESOURCES_PAYOUT = "/res/payout/";
    public static final String RESOURCES_SYSTEM = "/res/system/";
    public static final String DEV = "/res/dev/";
    public static final String DEV_BILL_DISP = "/res/dev/disp/bill/";
    public static final String DEV_PAYOUT = "/res/dev/payout/";
    public static final String PRN_TPL = "/res/templates/";
    public static final String PRN_TPL_DEF = "/res/templates/{0}/";
    public static final String PRN_TPL_COLLECT = "/res/templates/{0}/collect/";
    public static final String PRN_TPL_CUSTOM = "/res/templates/{0}/custom/";
    public static final String PRN_TPL_DIAG = "/res/templates/{0}/diag/";
    public static final String PRN_TPL_LOGO = "/res/templates/logo/";
    public static final String PRN_BARCODE = "/data/barcode/";
    public static final String TRADEMARK = "/res/trademark/";
    public static final String UPDATE_LIST_GZ = "/update/nlist.xml.gz";
    public static final String UPDATE_APP = "/update/app/";
    public static final String UPDATE_RES = "/update/res/";
    public static final String UPDATE_BANNERS = "/update/bnr/";
    public static final String UPDATE_ADVERT = "/update/ad/";
    public static final String CONTENT_BANNERS = "/content/banners/";
    public static final String CONTENT_ADVERT_2MON = "/content/ad/";
    public static final String CONTENT_STATIC_2MON = "/content/static/";
    public static final String CONTENT_DEFAULT_2MON = "/content/default/";
    public static final String LOG = "/log/";
    public static final String LOG_ADD = "/log/add/";
    public static final String LOG_DISP = "/log/disp/";
    public static final String KEYS = "/key/";
    public static final String JRE = "/jre/";
    public static final String JRE_UPD = "/jre/upd/";
    public static final String JRE_WORK = "/jre/work/";
    public static final String FIRMWARES = "/data/firmware/";
    public static final String DISIG_HOME = "/disig/";
    private static String path;

    private PathUtils() {
    }

    public static String getAppDrive() {
        File file = new File(PathUtils.getAppHome());
        while (file.getParentFile() != null) {
            file = file.getParentFile();
        }
        return file.getPath().replace("\\", "");
    }

    public static File getRoot(String path) {
        return new File(PathUtils.getAppHome(), ROOT);
    }

    public static File getFilePath(String path) {
        if (path == null) {
            throw new NullPointerException("Path is not set");
        }
        return new File(PathUtils.getAppHome(), path);
    }

    public static String getUrlPath(String path) {
        File f;
        if (path == null) {
            throw new NullPointerException("Path is not set");
        }
        URL url = PathUtils.class.getResource(path);
        if (url == null && (f = new File(".", path)).canRead()) {
            try {
                url = f.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            return null;
        }
        return url.toExternalForm();
    }

    public static String getPath(String path) {
        if (path == null) {
            throw new NullPointerException("Path is not set");
        }
        return new File(PathUtils.getAppHome(), path).getAbsolutePath();
    }

    public static String getAppHome() {
        String appHome = System.getProperty("app.home");
        if (appHome == null || appHome.isEmpty()) {
            File file = new File(new PathUtils().getPath());
            return new File(file.getParent()).getParent();
        }
        return appHome;
    }

    private synchronized String getPath() {
        if (path == null) {
            try {
                path = URLDecoder.decode(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), "utf-8");
            }
            catch (UnsupportedEncodingException ex) {
                path = this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
            }
        }
        return path;
    }
}

