/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.system.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import ru.softlogic.system.util.PathUtils;

public class DaemonUtil {
    private static String daemonBuild;

    public static synchronized void resetUpdateBuild() {
        daemonBuild = null;
    }

    public static synchronized String getUpdateBuild() {
        if (daemonBuild == null) {
            int val = 0;
            try {
                val = Integer.parseInt(FileUtils.readFileToString((File)PathUtils.getFilePath("update.build")));
                if (val < 0 || val > 99) {
                    val = 0;
                }
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
            daemonBuild = String.format("%02d", val);
        }
        return daemonBuild;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readObject(String filename, boolean delete) {
        Object object;
        File file = PathUtils.getFilePath("/data/" + filename);
        ObjectInputStream ois = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ois = new ObjectInputStream(fis);
            object = ois.readObject();
        }
        catch (IOException | ClassNotFoundException ex) {
            Object var6_7;
            try {
                var6_7 = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly(ois);
                if (delete) {
                    file.delete();
                }
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly(ois);
            if (delete) {
                file.delete();
            }
            return var6_7;
        }
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((InputStream)ois);
        if (delete) {
            file.delete();
        }
        return object;
    }

    public static void saveObject(Object object, String filename) throws Exception {
        if (object == null) {
            return;
        }
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(PathUtils.getFilePath("/data/" + filename));
            oos = new ObjectOutputStream(fos);
            oos.writeObject(object);
        }
        catch (IOException ex) {
            try {
                throw new Exception(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                IOUtils.closeQuietly(oos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)fos);
        IOUtils.closeQuietly((OutputStream)oos);
    }

    public static List<File> getDumps() {
        HashSet<File> paths = new HashSet<File>();
        paths.add(PathUtils.getFilePath("/"));
        paths.add(new File(System.getProperty("user.home"), File.separator));
        paths.add(new File(System.getProperty("user.dir"), File.separator));
        LinkedList<File> res = new LinkedList<File>();
        for (File path : paths) {
            res.addAll(DaemonUtil.getFiles(path));
        }
        Collections.sort(res, new Sorter());
        return res;
    }

    private static List<File> getFiles(File path) {
        File[] files = path.listFiles(pathname -> pathname.isFile() && pathname.getAbsolutePath().matches(".*hs_err_pid\\d{1,5}\\.log"));
        return Arrays.asList(files);
    }

    private static class Sorter
    implements Comparator<File> {
        private Sorter() {
        }

        @Override
        public int compare(File o1, File o2) {
            return Long.compare(o1.lastModified(), o2.lastModified());
        }
    }
}

