/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ru.softlogic.update.updater.ItemProgressListener;
import ru.softlogic.update.updater.ListInfo;
import ru.softlogic.update.updater.ProgressListener;
import ru.softlogic.update.updater.UpdateControl;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.exceptions.ChangeStoreException;
import ru.softlogic.update.updater.exceptions.CorruptedFileException;
import ru.softlogic.update.updater.exceptions.InvalidStoreException;
import ru.softlogic.update.updater.exceptions.RemoteFileNotFoundException;
import ru.softlogic.update.updater.filter.Filter;

class Updater {
    private final UpdateStore us;
    private final File appDir;
    private final File updateDir;
    private final File list;
    private final Logger log;
    private ListInfo listInfo;

    public Updater(UpdateStore us, File appDir, File updateDir, File list, Logger log) {
        if (us == null) {
            throw new NullPointerException("UpdateStore");
        }
        if (appDir == null) {
            throw new NullPointerException("AppDir");
        }
        if (updateDir == null) {
            throw new NullPointerException("UpdateDir");
        }
        if (list == null) {
            throw new NullPointerException("List");
        }
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.us = us;
        this.appDir = appDir;
        this.updateDir = updateDir;
        this.list = list;
        this.log = log;
    }

    public UpdateSize getUpdateSize(Filter filter) throws IOException, RemoteFileNotFoundException, InvalidStoreException, CorruptedFileException {
        this.checkEnviroment();
        if (this.isNeedListUpdate()) {
            this.log.info((Object)"Needs to update list.xml");
            this.downloadList();
        } else {
            this.log.info((Object)"Update list.xml is not needed");
        }
        List<UpdateItem> items = this.getRequireUpdate(this.getItemsList(), filter);
        if (!items.isEmpty()) {
            int size = 0;
            LinkedList<String> files = new LinkedList<String>();
            for (UpdateItem ui : items) {
                size += ui.getSize();
                files.add(ui.getFilename());
            }
            return new UpdateSize(size, items.size(), files);
        }
        return null;
    }

    public void process(List<String> files, ProgressListener listener, UpdateControl updateControl) throws CorruptedFileException, IOException, RemoteFileNotFoundException, InvalidStoreException, ChangeStoreException {
        if (updateControl == null) {
            throw new NullPointerException("UpdateControl");
        }
        this.checkEnviroment();
        this.log.info((Object)"Start download");
        List<UpdateItem> items = this.getRequireUpdate(this.getItemsList(), files);
        this.processByList(items, listener, updateControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processByList(List<UpdateItem> items, ProgressListener listener, UpdateControl updateControl) throws RemoteFileNotFoundException, InvalidStoreException, ChangeStoreException, CorruptedFileException, IOException {
        this.log.info((Object)"Start download");
        if (!items.isEmpty()) {
            this.log.debug((Object)("Required items: " + items));
            int size = 0;
            for (int i = 0; i < items.size(); ++i) {
                size += items.get(i).getSize();
            }
            int downloaded = 0;
            for (int i = 0; i < items.size(); ++i) {
                UpdateItem ui = items.get(i);
                listener.onProgress(ui.getFilename(), size, downloaded);
                File dest = new File(this.updateDir, ui.getFilename());
                File destDir = dest.getParentFile();
                if (!destDir.exists()) {
                    destDir.mkdirs();
                }
                this.log.info((Object)("Start " + String.format("%2d", i + 1) + "/" + items.size() + " " + ui + "->" + dest));
                boolean success = false;
                for (int z = 0; z <= 15 && !success; ++z) {
                    try {
                        for (int j = 0; j < 2; ++j) {
                            this.us.download(ui, dest, new ItemProgressListener(listener, size, downloaded), Integer.toString(i + 1) + "/" + items.size());
                            long crc = Updater.calculateChecksum(dest);
                            if (ui.getCrc() == crc) break;
                            this.log.info((Object)("CRC is corrupted, ref value=" + ui.getCrc() + ", calculated value: " + crc + ", check list.xml changes"));
                            ListInfo curr = this.us.getListInfo();
                            if (!curr.equals(this.listInfo)) {
                                throw new ChangeStoreException("list.xml was changed on server. Needs to restart the update process");
                            }
                            if (j != 0) {
                                throw new CorruptedFileException("Crc " + dest.getAbsolutePath() + " is not correct");
                            }
                            dest.delete();
                        }
                        this.log.info((Object)"Downloaded!");
                        success = true;
                        continue;
                    }
                    catch (IOException ex) {
                        this.log.error((Object)ex, (Throwable)ex);
                        if (z < 20 && updateControl.confirmRetry(z, ex)) {
                            this.log.error((Object)("Sleep " + z * 5 + " seconds"));
                            try {
                                TimeUnit.SECONDS.sleep((long)z * 5L);
                                continue;
                            }
                            catch (InterruptedException ex1) {
                                Thread.currentThread().interrupt();
                                throw new IOException(ex);
                            }
                        }
                        throw ex;
                    }
                    finally {
                        dest.setLastModified(ui.getMtime());
                    }
                }
                listener.onProgress(ui.getFilename(), size, downloaded += ui.getSize());
            }
        } else {
            this.log.info((Object)"Nothing todo");
        }
    }

    public List<UpdateItem> getRequireUpdate(List<UpdateItem> avaliable, Filter filter) {
        if (avaliable == null) {
            throw new NullPointerException("List<UpdateItem>");
        }
        this.log.info((Object)"Check files crc");
        LinkedList<UpdateItem> result = new LinkedList<UpdateItem>();
        for (UpdateItem ui : avaliable) {
            if (!filter.isAllow(ui)) {
                this.log.debug((Object)("Item is not allowed by external filter: " + ui));
                continue;
            }
            File updFile = new File(this.updateDir, ui.getFilename());
            if (updFile.exists()) {
                if (ui.getCrc() == Updater.calculateChecksum(updFile).longValue()) continue;
                result.add(ui);
                continue;
            }
            File mainFile = new File(this.appDir, ui.getFilename());
            if (mainFile.exists() && ui.getCrc() == Updater.calculateChecksum(mainFile).longValue()) continue;
            result.add(ui);
        }
        this.log.info((Object)"Check complete");
        return result;
    }

    public List<UpdateItem> getRequireUpdate(List<UpdateItem> avaliable, List<String> required) {
        if (avaliable == null) {
            throw new NullPointerException("List<UpdateItem>");
        }
        LinkedList<UpdateItem> result = new LinkedList<UpdateItem>();
        for (UpdateItem ui : avaliable) {
            if (!required.contains(ui.getFilename())) continue;
            result.add(ui);
        }
        return result;
    }

    private List<UpdateItem> getItemsList() throws CorruptedFileException {
        LinkedList<UpdateItem> linkedList;
        LinkedList<UpdateItem> result = new LinkedList<UpdateItem>();
        GZIPInputStream gzis = null;
        try {
            gzis = new GZIPInputStream(new FileInputStream(this.list));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(gzis);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            NodeList nl = root.getElementsByTagName("file");
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element element = (Element)nl.item(i);
                    String fileName = element.getAttribute("name");
                    long crc = Long.parseLong(element.getAttribute("crc"));
                    int size = Integer.parseInt(element.getAttribute("size"));
                    long mtime = Long.parseLong(element.getAttribute("mtime"));
                    result.add(new UpdateItem(fileName, crc, size, mtime));
                }
            }
            linkedList = result;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            try {
                throw new CorruptedFileException(ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(gzis);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)gzis);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadList() throws IOException, RemoteFileNotFoundException, InvalidStoreException, CorruptedFileException {
        this.log.info((Object)"Download update items list");
        if (this.listInfo == null) {
            this.log.info((Object)"Get list info");
            this.listInfo = this.us.getListInfo();
        }
        long localCrc = 0L;
        for (int i = 0; i < 2; ++i) {
            this.log.info((Object)("attempt " + (i + 1)));
            UpdateItem ui = new UpdateItem(this.listInfo.getFilename(), this.listInfo.getCrc(), this.listInfo.getSize(), this.listInfo.getMtime());
            try {
                this.us.download(ui, this.list, null, null);
            }
            finally {
                this.list.setLastModified(ui.getMtime());
            }
            this.log.info((Object)"Downloaded");
            localCrc = Updater.calculateChecksum(this.list);
            this.log.info((Object)("Local crc=" + localCrc + ", remote crc=" + this.listInfo.getCrc()));
            if (localCrc != this.listInfo.getCrc()) {
                this.log.info((Object)"Try to refresh remote crc");
                this.listInfo = this.us.getListInfo();
                this.log.info((Object)("Success, remote crc=" + this.listInfo.getCrc()));
            }
            if (localCrc == this.listInfo.getCrc()) {
                return;
            }
            this.log.info((Object)"Crc not correct, try one more");
            this.list.delete();
        }
        throw new CorruptedFileException("Crc list.xm is not correct, local crc=" + localCrc + ", remote crc=" + this.listInfo.getCrc());
    }

    private void checkEnviroment() throws InvalidStoreException {
        if (!this.appDir.exists()) {
            throw new InvalidStoreException("Application dir not exist");
        }
        if (!this.appDir.isDirectory()) {
            throw new InvalidStoreException("Application dir is not directory");
        }
        if (!this.updateDir.exists()) {
            if (!this.updateDir.mkdirs()) {
                throw new InvalidStoreException("Can' create update folder");
            }
        } else if (!this.updateDir.isDirectory()) {
            throw new InvalidStoreException("Update dir is not directory");
        }
        if (this.updateDir.getFreeSpace() < 0x3200000L) {
            throw new InvalidStoreException("Disk has no free space. Exit");
        }
    }

    private boolean isNeedListUpdate() throws IOException, RemoteFileNotFoundException {
        this.log.info((Object)"Check for updates");
        if (!this.list.exists()) {
            return true;
        }
        Long localCrc = Updater.calculateChecksum(this.list);
        if (localCrc == null) {
            return true;
        }
        this.listInfo = this.us.getListInfo();
        return localCrc.longValue() != this.listInfo.getCrc();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long calculateChecksum(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            int l2;
            CRC32 cs = new CRC32();
            cs.reset();
            byte[] buf = new byte[1024];
            while ((l2 = fis.read(buf)) >= 0) {
                cs.update(buf, 0, l2);
            }
            Long l = cs.getValue();
            return l;
        }
        catch (IOException ex) {
            return null;
        }
    }
}

