/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import ru.softlogic.update.updater.ProgressListener;
import ru.softlogic.update.updater.StateListener;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateMetric;
import ru.softlogic.update.updater.UpdateRequest;
import ru.softlogic.update.updater.UpdateSize;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.Updater;
import ru.softlogic.update.updater.exceptions.ChangeStoreException;
import ru.softlogic.update.updater.exceptions.UpdateException;

public class UpdateHandler
implements Runnable {
    private final Logger log;
    private final StateListener system;
    private final BlockingQueue<UpdateRequest> queue;
    private boolean inProcess;

    public UpdateHandler(StateListener system, Logger log) {
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.system = system;
        this.log = log;
        this.queue = new LinkedBlockingQueue<UpdateRequest>();
    }

    public boolean addUpdateRequest(UpdateRequest updateRequest) {
        if (updateRequest == null) {
            throw new NullPointerException("Request is null");
        }
        this.queue.add(updateRequest);
        return true;
    }

    public int getQueueSize() {
        this.log.info((Object)("Queue size: " + this.queue.size() + ", in process: " + this.inProcess));
        return this.queue.size() + (this.inProcess ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.log.info((Object)"Start thread");
        while (!Thread.currentThread().isInterrupted()) {
            try {
                this.inProcess = false;
                UpdateRequest ur = this.queue.take();
                this.inProcess = true;
                StateListener client = ur.getStateListener();
                UpdateStore us = ur.getUpdateStore();
                this.log.info((Object)("Get update request, url: " + us.getUrl() + ", store path: " + ur.getUpdateDir()));
                Updater updater = new Updater(us, ur.getAppDir(), ur.getUpdateDir(), ur.getList(), this.log);
                try {
                    boolean success = false;
                    for (int j = 0; j < 2; ++j) {
                        try {
                            this.notifyStart(client);
                            if (ur.getItems() == null || ur.getItems().isEmpty()) {
                                this.log.info((Object)"Items is not set, request update size");
                                UpdateSize updateSize = updater.getUpdateSize(ur.getFilter());
                                if (updateSize == null) {
                                    this.log.info((Object)"Nothing todo");
                                    this.notifySkip(client);
                                } else if (ur.getUpdateControl().confirmUpdate(updateSize.getSize())) {
                                    this.log.info((Object)"Update confirmed");
                                    this.notifyConfirm(client, updateSize);
                                    long start = System.currentTimeMillis();
                                    updater.process(updateSize.getFiles(), new LocalProgressListener(client), ur.getUpdateControl());
                                    long timeout = System.currentTimeMillis() - start;
                                    if (timeout > 0L) {
                                        this.log.info((Object)("Download time: " + String.format("%.2f", (double)timeout * 1.0 / 1000.0) + " s"));
                                        this.log.info((Object)("Average speed: " + String.format("%.2f", (double)updateSize.getSize() * 1.0 / 1024.0 * 1000.0 / (double)timeout) + " kBps"));
                                    }
                                    this.notifySuccess(client, new UpdateMetric(updateSize.getSize(), updateSize.getCount(), timeout));
                                } else {
                                    this.log.info((Object)"Update not confirmed");
                                    this.notifyCancel(client);
                                }
                                success = true;
                                break;
                            }
                            this.log.info((Object)("Process update by list: " + ur.getItems()));
                            List<UpdateItem> reqList = updater.getRequireUpdate(ur.getItems(), ur.getFilter());
                            this.log.info((Object)("Filtered: " + reqList));
                            if (!reqList.isEmpty()) {
                                int size = 0;
                                for (UpdateItem i : reqList) {
                                    size += i.getSize();
                                }
                                UpdateSize updateSize = new UpdateSize(size, reqList.size(), null);
                                long start = System.currentTimeMillis();
                                updater.processByList(reqList, new LocalProgressListener(client), ur.getUpdateControl());
                                long timeout = System.currentTimeMillis() - start;
                                if (timeout > 0L) {
                                    this.log.info((Object)("Download time: " + String.format("%.2f", (double)timeout * 1.0 / 1000.0) + " s"));
                                    this.log.info((Object)("Average speed: " + String.format("%.2f", (double)updateSize.getSize() * 1.0 / 1024.0 * 1000.0 / (double)timeout) + " kBps"));
                                }
                                this.notifySuccess(client, new UpdateMetric(updateSize.getSize(), updateSize.getCount(), timeout));
                            } else {
                                this.log.info((Object)"Nothing todo");
                                this.notifySkip(client);
                            }
                            success = true;
                            break;
                        }
                        catch (ChangeStoreException ex) {
                            this.log.info((Object)"Needs to restart process", (Throwable)ex);
                            continue;
                        }
                    }
                    if (success) {
                        this.log.info((Object)"Update successfully finished");
                        continue;
                    }
                    throw new UpdateException(true, "Volative store");
                }
                catch (UpdateException ex) {
                    this.log.error((Object)"An error occurred when updating: ", (Throwable)ex);
                    if (ex.isGlobalError()) {
                        this.notifyGlobalError(client, ex);
                        continue;
                    }
                    this.notifyLocalError(client, ex, null);
                }
                catch (IOException ex) {
                    this.log.error((Object)"An error occurred when updating: ", (Throwable)ex);
                    this.notifyLocalError(client, ex, null);
                }
                catch (CancelException ex) {
                    this.log.info((Object)"Interrupt updater thread");
                    break;
                }
                finally {
                    this.log.info((Object)"Close update store");
                    try {
                        us.close();
                        this.log.info((Object)"Done");
                    }
                    catch (IOException ex) {
                        this.log.info((Object)"Error on close", (Throwable)ex);
                    }
                }
            }
            catch (InterruptedException ex) {
                this.log.warn((Object)"Thread was interrupted");
                Thread.currentThread().interrupt();
            }
        }
        this.log.info((Object)"Stop thread");
    }

    private void notifyStart(StateListener client) {
        if (this.system != null) {
            this.system.onStart();
        }
        client.onStart();
    }

    private void notifySkip(StateListener client) {
        this.inProcess = false;
        if (this.system != null) {
            this.system.onSkip();
        }
        client.onSkip();
    }

    private void notifyCancel(StateListener client) {
        this.inProcess = false;
        if (this.system != null) {
            this.system.onCancel();
        }
        client.onCancel();
    }

    private void notifySuccess(StateListener client, UpdateMetric um) throws CancelException {
        this.inProcess = false;
        if (this.system != null) {
            this.system.onSuccess(um);
        }
        boolean rebootFlag = client.onSuccess(um);
        this.log.info((Object)("Reboot flag: " + rebootFlag));
        if (rebootFlag) {
            throw new CancelException();
        }
    }

    private void notifyConfirm(StateListener client, UpdateSize size) {
        if (this.system != null) {
            this.system.onConfirm(size);
        }
        client.onConfirm(size);
    }

    private void notifyGlobalError(StateListener client, Exception ex) {
        this.inProcess = false;
        if (this.system != null) {
            this.system.onGlobalError(ex);
        }
        client.onGlobalError(ex);
    }

    private void notifyLocalError(StateListener client, Exception ex, UpdateMetric metric) {
        this.inProcess = false;
        if (this.system != null) {
            this.system.onLocalError(ex, metric);
        }
        client.onLocalError(ex, metric);
    }

    private final class CancelException
    extends Exception {
    }

    private class LocalProgressListener
    implements ProgressListener {
        private final StateListener stateListener;

        public LocalProgressListener(StateListener stateListener) {
            this.stateListener = stateListener;
        }

        @Override
        public void onProgress(String title, int total, int progress) {
            this.stateListener.onProgress(title, total, progress);
        }
    }
}

