/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.updater;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Random;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import ru.softlogic.update.updater.ListInfo;
import ru.softlogic.update.updater.ProgressListener;
import ru.softlogic.update.updater.UpdateItem;
import ru.softlogic.update.updater.UpdateStore;
import ru.softlogic.update.updater.exceptions.CreateStoreException;
import ru.softlogic.update.updater.exceptions.InvalidStoreException;
import ru.softlogic.update.updater.exceptions.RemoteFileNotFoundException;

public class HttpUpdateStore
implements UpdateStore {
    private static final int BUFFER_SIZE = 32768;
    private final String url;
    private final int point;
    private final CloseableHttpClient client;
    private final Logger log;
    private final Random rnd = new Random();

    public HttpUpdateStore(String url, int point, Logger log) throws CreateStoreException {
        this(url, null, null, point, log);
    }

    public HttpUpdateStore(String url, String login, String password, int point, Logger log) throws CreateStoreException {
        if (url == null) {
            throw new CreateStoreException("Url not specify");
        }
        if (point < 0) {
            throw new CreateStoreException("Point must be positive");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.url = (url + "/").replaceAll("([^:])//", "$1/");
        this.point = point;
        this.log = log;
        try {
            URL u = new URL(url);
            int port = u.getPort();
            if (port < 0) {
                port = u.getDefaultPort();
            }
            BasicCredentialsProvider cp = null;
            if (login != null && password != null) {
                cp = new BasicCredentialsProvider();
                cp.setCredentials(new AuthScope(u.getHost(), port), (Credentials)new UsernamePasswordCredentials(login, password));
            }
            this.client = this.createClient((CredentialsProvider)cp);
        }
        catch (MalformedURLException ex) {
            throw new CreateStoreException(ex);
        }
    }

    @Override
    public void download(UpdateItem item, File dest, ProgressListener listener, String addInfo) throws IOException, RemoteFileNotFoundException, InvalidStoreException {
        CloseableHttpResponse response;
        int resultCode;
        long rangeBegin = this.getRange(item, dest);
        HttpPost post = new HttpPost(this.url + item.getFilename().replace(" ", "%20") + this.getRnd());
        post.addHeader((Header)new BasicHeader("X-PayLogic-Update", "Pay-logic " + this.point));
        if (addInfo != null && !addInfo.isEmpty()) {
            post.addHeader((Header)new BasicHeader("X-PayLogic-Progress", addInfo));
        }
        if (rangeBegin > 0L) {
            post.addHeader((Header)new BasicHeader("Range", "bytes=" + rangeBegin + "-"));
        }
        if ((resultCode = (response = this.client.execute((HttpUriRequest)post)).getStatusLine().getStatusCode()) == 404) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new RemoteFileNotFoundException(item.getFilename());
        }
        if (resultCode == 416) {
            this.log.error((Object)("Get code: " + resultCode + ", delete file: " + dest.delete()));
            throw new IOException("Error " + response.getStatusLine().getStatusCode() + ", " + response.getStatusLine().getReasonPhrase());
        }
        if (resultCode != 200 && (resultCode != 206 || rangeBegin <= 0L)) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new IOException("Error " + response.getStatusLine().getStatusCode() + ", " + response.getStatusLine().getReasonPhrase());
        }
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (InputStream is = entity.getContent();
                 FileOutputStream fos = new FileOutputStream(dest, rangeBegin > 0L);){
                int len;
                byte[] buf = new byte[10000];
                int total = 0;
                while ((len = is.read(buf)) >= 0) {
                    fos.write(buf, 0, len);
                    total += len;
                    if (listener == null) continue;
                    listener.onProgress(item.getFilename(), item.getSize(), total);
                }
            }
        }
    }

    @Override
    public ListInfo getListInfo() throws IOException, RemoteFileNotFoundException {
        HttpPost post = new HttpPost(this.url + "nlist.crc" + this.getRnd());
        post.addHeader((Header)new BasicHeader("X-PayLogic-Update", "Pay-logic " + this.point));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)post);
        if (response.getStatusLine().getStatusCode() == 404) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new RemoteFileNotFoundException("list.crc, " + response.getStatusLine().toString());
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new IOException("Http error " + response.getStatusLine().getStatusCode());
        }
        String remoteData = EntityUtils.toString((HttpEntity)response.getEntity());
        if (remoteData == null || remoteData.isEmpty()) {
            throw new IOException("Data is not correct: " + remoteData);
        }
        for (String line : remoteData.split("\n")) {
            String[] dt;
            String f = line.trim();
            if (!f.matches("^(\\d+) (\\d+) (\\d+) (\\S+)$") || !"nlist.xml.gz".equals((dt = f.split(" "))[3])) continue;
            return new ListInfo(dt[3], Long.parseLong(dt[0]), Integer.parseInt(dt[1]), Long.parseLong(dt[2]));
        }
        throw new RemoteFileNotFoundException("Record with file nlist.xml.gz is not found. Content: " + remoteData);
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    private CloseableHttpClient createClient(CredentialsProvider cp) throws CreateStoreException {
        try {
            SSLContext sslcontext = this.buildSSLContext();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslcontext);
            Registry registry = RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)sslsf).build();
            BasicHttpClientConnectionManager cm = new BasicHttpClientConnectionManager((Lookup)registry);
            RequestConfig config = RequestConfig.custom().setSocketTimeout(120000).setConnectTimeout(120000).build();
            ConnectionConfig connConfig = ConnectionConfig.custom().setBufferSize(32768).build();
            HttpClientBuilder hcb = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setConnectionManager((HttpClientConnectionManager)cm).setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(5, false)).setSSLHostnameVerifier((HostnameVerifier)new NoopHostnameVerifier()).setDefaultConnectionConfig(connConfig).setDefaultRequestConfig(config).disableContentCompression().setUserAgent("Soft-logic updater/3.0.0");
            if (cp != null) {
                hcb.setDefaultCredentialsProvider(cp);
            }
            return hcb.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException ex) {
            throw new CreateStoreException("Erron on create HttpClient", ex);
        }
    }

    private SSLContext buildSSLContext() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
        return SSLContexts.custom().setSecureRandom(new SecureRandom()).loadTrustMaterial(null, (chain, authType) -> true).build();
    }

    private String getRnd() {
        return "?rnd=" + this.rnd.nextInt(10000000);
    }

    private long getRange(UpdateItem item, File dest) throws IOException, InvalidStoreException {
        if (dest.exists()) {
            if (!dest.canWrite()) {
                throw new IOException("Can't write dest file: " + dest.getAbsolutePath());
            }
            if (dest.lastModified() == item.getMtime() && dest.length() < (long)item.getSize()) {
                this.log.info((Object)("range begin=" + dest.length()));
                return dest.length();
            }
        } else {
            try {
                if (!dest.createNewFile()) {
                    throw new IOException("Can't create new file: " + dest.getAbsolutePath());
                }
            }
            catch (IOException ex) {
                throw new InvalidStoreException("Can't create new file: " + dest.getAbsolutePath(), (Throwable)ex);
            }
        }
        return 0L;
    }
}

