/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.update.postproc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import ru.softlogic.update.postproc.FileProcessor;

public class BZipDecompressor
implements FileProcessor {
    private Logger log;
    private final byte[] buffer = new byte[5000];

    public BZipDecompressor(Logger log) {
        if (log == null) {
            throw new NullPointerException("Logger");
        }
        this.log = log;
    }

    @Override
    public void process(File f) throws IOException {
        FileInputStream fin = null;
        BufferedInputStream in = null;
        FileOutputStream out = null;
        BZip2CompressorInputStream gzIn = null;
        try {
            String srcPath = f.getAbsolutePath();
            fin = new FileInputStream(srcPath);
            in = new BufferedInputStream(fin);
            String dstPath = srcPath.substring(0, srcPath.length() - ".bz2".length());
            this.log.info((Object)("    " + f + "->" + dstPath));
            out = new FileOutputStream(dstPath);
            gzIn = new BZip2CompressorInputStream((InputStream)in);
            int n = 0;
            while (-1 != (n = gzIn.read(this.buffer))) {
                out.write(this.buffer, 0, n);
            }
            this.log.info((Object)"        Uncompress successfully finished");
        }
        catch (IOException ex) {
            try {
                throw new IOException("An error occurred while uncompressing file: " + f, ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fin);
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(gzIn);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fin);
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
        IOUtils.closeQuietly((InputStream)gzIn);
        if (f.delete()) {
            this.log.info((Object)"        BZip archive successfully removed");
        } else {
            this.log.info((Object)"        An error occurred while removing the bzip archive");
        }
    }
}

