/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.ppp;

import java.io.File;
import java.io.UnsupportedEncodingException;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;

class WindowsConnectionManager
implements ConnectionManager {
    WindowsConnectionManager() {
    }

    @Override
    public String[] getConnectionsList() throws RPCException, DialupException {
        byte[][] result = this.getConnectionsListNative();
        if (result == null) {
            return null;
        }
        String[] res = new String[result.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                res[i] = new String(result[i], "cp1251");
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                res[i] = new String(result[i]);
            }
        }
        return res;
    }

    @Override
    public String[] getActiveConnectionsList() throws RPCException, DialupException {
        byte[][] result = this.getActiveConnectionsListNative();
        if (result == null) {
            return null;
        }
        String[] res = new String[result.length];
        for (int i = 0; i < result.length; ++i) {
            try {
                res[i] = new String(result[i], "cp1251");
                continue;
            }
            catch (UnsupportedEncodingException ex) {
                res[i] = new String(result[i]);
            }
        }
        return res;
    }

    @Override
    public void connect(String name) throws RPCException, DialupException {
        byte[] bytes;
        this.checkName(name);
        try {
            bytes = name.getBytes("cp1251");
        }
        catch (Exception ex) {
            bytes = name.getBytes();
        }
        this.connectNative(bytes);
    }

    @Override
    public void disconnect(String name) throws RPCException, DialupException {
        byte[] bytes;
        this.checkName(name);
        try {
            bytes = name.getBytes("cp1251");
        }
        catch (Exception ex) {
            bytes = name.getBytes();
        }
        this.disconnectNative(bytes);
    }

    @Override
    public void disconnectAll() throws RPCException, DialupException {
        this.disconnectAllNative();
    }

    @Override
    public int getConnectionState(String name) throws RPCException, DialupException {
        byte[] bytes;
        this.checkName(name);
        try {
            bytes = name.getBytes("cp1251");
        }
        catch (Exception ex) {
            bytes = name.getBytes();
        }
        return this.getConnectionStateNative(bytes);
    }

    private void checkName(String name) throws DialupException {
        if (name == null || name.isEmpty()) {
            throw new DialupException("Connection name is not set");
        }
    }

    private native byte[][] getConnectionsListNative() throws RPCException, DialupException;

    private native byte[][] getActiveConnectionsListNative() throws RPCException, DialupException;

    private native void connectNative(byte[] var1) throws RPCException, DialupException;

    private native void disconnectNative(byte[] var1) throws RPCException, DialupException;

    private native void disconnectAllNative() throws RPCException, DialupException;

    private native int getConnectionStateNative(byte[] var1) throws RPCException, DialupException;

    private boolean isInterrupt() {
        return Thread.currentThread().isInterrupted();
    }

    static {
        String archDataModel = System.getProperty("sun.arch.data.model");
        System.load(System.getProperty("java.library.path") + File.separator + archDataModel + File.separator + "ppp.dll");
    }
}

