/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.ppp;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.Logger;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;

public class LinuxProcConnectionManager
implements ConnectionManager {
    private final String[] names;
    private final Logger log = Logger.getLogger(ConnectionManager.class);

    public LinuxProcConnectionManager() {
        this.names = new String[]{"GPRS"};
    }

    @Override
    public String[] getConnectionsList() throws RPCException, DialupException {
        return this.names;
    }

    @Override
    public String[] getActiveConnectionsList() throws RPCException, DialupException {
        if (this.getConnectionState(this.names[0]) == 0) {
            return this.names;
        }
        return new String[0];
    }

    @Override
    public void connect(String name) throws RPCException, DialupException {
        this.checkName(name);
        try {
            Process p = Runtime.getRuntime().exec("./bin/script.sh start-ppp");
            p.waitFor();
        }
        catch (IOException ex) {
            throw new DialupException("Error on starting ppp-connection", ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new DialupException(ex);
        }
    }

    @Override
    public void disconnect(String name) throws RPCException, DialupException {
        this.checkName(name);
        this.disconnectAll();
    }

    @Override
    public void disconnectAll() throws RPCException, DialupException {
        try {
            Process p = Runtime.getRuntime().exec("./bin/script.sh stop-ppp");
            p.waitFor();
        }
        catch (IOException ex) {
            throw new DialupException("Error on stopping ppp-connection", ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new DialupException(ex);
        }
    }

    @Override
    public int getConnectionState(String name) throws RPCException, DialupException {
        this.checkName(name);
        File f = new File("/var/run/wvdial.pid");
        if (f.canRead()) {
            try {
                String pidStr = this.readFile(f).trim();
                this.log.debug((Object)("pid: " + pidStr));
                File proc = new File("/proc/" + pidStr + "/cmdline");
                if (proc.canRead()) {
                    String procPath = this.readFile(proc).trim();
                    this.log.debug((Object)("proc: " + proc));
                    return procPath.contains("wvdial") ? 0 : 1;
                }
                this.log.error((Object)("Can't read " + proc.getAbsolutePath()));
            }
            catch (IOException ex) {
                this.log.error((Object)"Error on read file", (Throwable)ex);
            }
        } else {
            this.log.error((Object)("Can't read " + f.getAbsolutePath()));
        }
        return 1;
    }

    private void checkName(String name) throws DialupException {
        if (name == null || name.isEmpty()) {
            throw new DialupException("Connection name is null or empty");
        }
        if (!name.equals(this.names[0])) {
            throw new DialupException("Connection name must be: " + this.names[0]);
        }
    }

    private String readFile(File file) throws IOException {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String string = br.readLine();
            return string;
        }
    }
}

