/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.ppp;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.freedesktop.DBus;
import org.freedesktop.dbus.DBusConnection;
import org.freedesktop.dbus.DBusInterface;
import org.freedesktop.dbus.DBusInterfaceName;
import org.freedesktop.dbus.DBusMemberName;
import org.freedesktop.dbus.Path;
import org.freedesktop.dbus.UInt32;
import org.freedesktop.dbus.Variant;
import org.freedesktop.dbus.exceptions.DBusException;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;

public class LinuxDbusConnectionManager
implements ConnectionManager {
    private static final String NetworkManager = "org.freedesktop.NetworkManager";
    private static final String ActiveConnection = "org.freedesktop.NetworkManager.Connection.Active";
    private static final String Devices = "org.freedesktop.NetworkManager.Device";
    private static final String GSM = "gsm";
    private static final String NetworkManager_Path = "/org/freedesktop/NetworkManager";
    private static final String Settings_Path = "/org/freedesktop/NetworkManager/Settings";
    private DBusConnection dbusConnection;
    private Map<String, String> ids = new LinkedHashMap<String, String>();

    @Override
    public String[] getConnectionsList() throws RPCException, DialupException {
        try {
            this.dBusConnect();
            return this.ids.values().toArray(new String[this.ids.size()]);
        }
        catch (DBusException ex) {
            this.dBusDisconnect();
            throw new DialupException(ex);
        }
    }

    @Override
    public String[] getActiveConnectionsList() throws RPCException, DialupException {
        try {
            this.dBusConnect();
            LinkedList<String> result = new LinkedList<String>();
            DBus.Properties property = (DBus.Properties)this.dbusConnection.getRemoteObject(NetworkManager, NetworkManager_Path, DBus.Properties.class);
            List allActive = (List)property.Get(NetworkManager, "ActiveConnections");
            for (Path path : allActive) {
                DBus.Properties info = (DBus.Properties)this.dbusConnection.getRemoteObject(NetworkManager, path.toString(), DBus.Properties.class);
                Path connPath = (Path)((DBus.Properties)this.dbusConnection.getRemoteObject(NetworkManager, path.getPath(), DBus.Properties.class)).Get(ActiveConnection, "Connection");
                String type = (String)((Connection)this.dbusConnection.getRemoteObject(NetworkManager, connPath.toString(), Connection.class)).getSettings().get("connection").get("type").getValue();
                if (!GSM.equals(type)) continue;
                result.add(this.ids.get((String)info.Get(ActiveConnection, "Uuid")));
            }
            return result.toArray(new String[result.size()]);
        }
        catch (DBusException ex) {
            this.dBusDisconnect();
            throw new DialupException(ex);
        }
    }

    @Override
    public void connect(String name) throws RPCException, DialupException {
        this.checkName(name);
        try {
            this.dBusConnect();
            if (this.getConnectionState(name) != 1) {
                return;
            }
            Settings settings = (Settings)this.dbusConnection.getRemoteObject(NetworkManager, Settings_Path, Settings.class);
            for (Path setting_path : settings.getListConnections()) {
                String cm;
                Map<String, Variant> info = ((Connection)this.dbusConnection.getRemoteObject(NetworkManager, setting_path.toString(), Connection.class)).getSettings().get("connection");
                if (info.get("uuid") == null || (cm = this.ids.get((String)info.get("uuid").getValue())) == null || !name.equals(cm)) continue;
                NetworkManager nm = (NetworkManager)this.dbusConnection.getRemoteObject(NetworkManager, NetworkManager_Path, NetworkManager.class);
                for (Path device : nm.getDevices()) {
                    DBus.Properties property = (DBus.Properties)this.dbusConnection.getRemoteObject(NetworkManager, device.toString(), DBus.Properties.class);
                    List availableConnections = (List)property.Get(Devices, "AvailableConnections");
                    for (Path ac : availableConnections) {
                        if (!ac.toString().equals(setting_path.toString())) continue;
                        nm.connect(ac, device, new Path("/"));
                        return;
                    }
                }
            }
            throw new DialupException("Connection '" + name + "' is not found");
        }
        catch (DBusException ex) {
            this.dBusDisconnect();
            throw new DialupException(ex);
        }
    }

    @Override
    public void disconnect(String name) throws RPCException, DialupException {
        try {
            this.dBusConnect();
            DBus.Properties property = (DBus.Properties)this.dbusConnection.getRemoteObject(NetworkManager, NetworkManager_Path, DBus.Properties.class);
            List allActive = (List)property.Get(NetworkManager, "ActiveConnections");
            for (Path path : allActive) {
                DBus.Properties info = (DBus.Properties)this.dbusConnection.getRemoteObject(NetworkManager, path.toString(), DBus.Properties.class);
                if (!name.equals(this.ids.get((String)info.Get(ActiveConnection, "Uuid")))) continue;
                NetworkManager nm = (NetworkManager)this.dbusConnection.getRemoteObject(NetworkManager, NetworkManager_Path, NetworkManager.class);
                nm.disconnect(path);
                return;
            }
            throw new DialupException("Connection '" + name + "' is not found");
        }
        catch (DBusException ex) {
            this.dBusDisconnect();
            throw new DialupException(ex);
        }
    }

    @Override
    public void disconnectAll() throws RPCException, DialupException {
        for (String conn : this.getActiveConnectionsList()) {
            this.disconnect(conn);
        }
    }

    @Override
    public int getConnectionState(String name) throws RPCException, DialupException {
        try {
            int state = 1;
            this.dBusConnect();
            DBus.Properties property = (DBus.Properties)this.dbusConnection.getRemoteObject(NetworkManager, NetworkManager_Path, DBus.Properties.class);
            List allActive = (List)property.Get(NetworkManager, "ActiveConnections");
            for (Path path : allActive) {
                DBus.Properties info = (DBus.Properties)this.dbusConnection.getRemoteObject(NetworkManager, path.toString(), DBus.Properties.class);
                if (!name.equals(this.ids.get((String)info.Get(ActiveConnection, "Uuid")))) continue;
                UInt32 st = (UInt32)info.Get(ActiveConnection, "State");
                if (st.intValue() == 1) {
                    state = 2;
                    break;
                }
                if (st.intValue() == 2) {
                    state = 0;
                    break;
                }
                state = 1;
                break;
            }
            return state;
        }
        catch (DBusException ex) {
            this.dBusDisconnect();
            throw new DialupException(ex);
        }
    }

    private void checkName(String name) throws DialupException {
        if (name == null || name.isEmpty()) {
            throw new DialupException("Connection name is null or empty");
        }
    }

    private void dBusConnect() throws DBusException {
        if (this.dbusConnection == null) {
            this.dbusConnection = DBusConnection.getConnection((int)0);
            Settings settings = (Settings)this.dbusConnection.getRemoteObject(NetworkManager, Settings_Path, Settings.class);
            for (Path path : settings.getListConnections()) {
                Map<String, Variant> info = ((Connection)this.dbusConnection.getRemoteObject(NetworkManager, path.toString(), Connection.class)).getSettings().get("connection");
                if (!GSM.equals(info.get("type").getValue())) continue;
                this.ids.put((String)info.get("uuid").getValue(), (String)info.get("id").getValue());
            }
        }
    }

    private void dBusDisconnect() {
        if (this.dbusConnection != null) {
            this.dbusConnection.disconnect();
        }
    }

    @DBusInterfaceName(value="org.freedesktop.NetworkManager.Settings.Connection")
    public static interface Connection
    extends DBusInterface {
        @DBusMemberName(value="GetSettings")
        public Map<String, Map<String, Variant>> getSettings();
    }

    @DBusInterfaceName(value="org.freedesktop.NetworkManager.Settings")
    public static interface Settings
    extends DBusInterface {
        @DBusMemberName(value="ListConnections")
        public List<Path> getListConnections();
    }

    @DBusInterfaceName(value="org.freedesktop.NetworkManager")
    private static interface NetworkManager
    extends DBusInterface {
        @DBusMemberName(value="ActivateConnection")
        public Path connect(Path var1, Path var2, Path var3);

        @DBusMemberName(value="DeactivateConnection")
        public void disconnect(Path var1);

        @DBusMemberName(value="GetDevices")
        public List<Path> getDevices();
    }
}

