/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.ppp;

import java.util.ResourceBundle;
import ru.softlogic.ppp.Connection;
import ru.softlogic.ppp.ConnectionManager;
import ru.softlogic.ppp.DialupException;
import ru.softlogic.ppp.RPCException;

public class BaseConnection
implements Connection {
    private static final ResourceBundle bundle = ResourceBundle.getBundle(Connection.class.getPackage().getName() + ".messages");
    private final String name;
    private final ConnectionManager manager;

    public BaseConnection(String name, ConnectionManager manager) {
        if (name == null) {
            throw new NullPointerException("Name is null");
        }
        if (manager == null) {
            throw new NullPointerException("ConnectionManager is null");
        }
        this.name = name;
        this.manager = manager;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void connect() throws RPCException, DialupException {
        this.manager.connect(this.name);
    }

    @Override
    public void disconnect() throws RPCException, DialupException {
        this.manager.disconnect(this.name);
    }

    @Override
    public int getState() throws RPCException, DialupException {
        return this.manager.getConnectionState(this.name);
    }

    @Override
    public String getStateAsStr(int state) {
        try {
            return bundle.getString("state." + state);
        }
        catch (Throwable ex) {
            return "state." + state;
        }
    }
}

