/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.security;

import ru.softlogic.security.EmptySystemChecker;
import ru.softlogic.security.LinuxSystemChecker;
import ru.softlogic.security.RiskFactors;
import ru.softlogic.security.SystemCheckerImpl;
import ru.softlogic.security.WindowsSystemChecker;

public class SystemChecker {
    private static final SystemCheckerImpl instance = SystemChecker.getInstance();

    private SystemChecker() {
    }

    public static RiskFactors check() {
        return instance.getRiskFactors();
    }

    private static SystemCheckerImpl getInstance() {
        String osName = System.getProperty("os.name");
        if (osName != null) {
            if (osName.toLowerCase().contains("windows")) {
                return new WindowsSystemChecker();
            }
            if (osName.toLowerCase().contains("linux")) {
                return new LinuxSystemChecker();
            }
        }
        return new EmptySystemChecker();
    }
}

