/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.services.identify.range;

import java.io.File;
import java.util.Arrays;
import ru.softlogic.services.identify.range.BaseRangeIdentifier;

class SimpleRangeIdentifier
extends BaseRangeIdentifier {
    private int[] begin;
    private int[] end;
    private short[] prov;
    private boolean loaded = false;

    public SimpleRangeIdentifier(File dir) {
        super(dir);
    }

    @Override
    protected void onHeader(int count) {
        this.begin = new int[count];
        this.end = new int[count];
        this.prov = new short[count];
    }

    @Override
    protected void onRecord(int index, String b, String e, short operator) {
        this.begin[index] = Integer.parseInt(b);
        this.end[index] = Integer.parseInt(e);
        this.prov[index] = operator;
    }

    @Override
    protected void onError() {
        this.end = null;
        this.begin = null;
        this.loaded = false;
    }

    @Override
    protected void onSuccess() {
        this.loaded = true;
    }

    @Override
    public short getOperator(String number) {
        if (this.loaded && this.begin != null) {
            int num = Integer.parseInt(number);
            int index = Arrays.binarySearch(this.begin, num);
            if (index > 0) {
                return this.prov[index];
            }
            if ((index = -index - 1) < this.begin.length) {
                if (this.begin[index] > num) {
                    for (int i = index - 1; i >= 0; --i) {
                        if (this.begin[i] >= num) continue;
                        return this.end[i] > num ? this.prov[i] : (short)-1;
                    }
                } else {
                    for (int i = index; i < this.begin.length; ++i) {
                        if (this.end[i] < num) continue;
                        return this.begin[i] < num ? this.prov[i] : (short)-1;
                    }
                }
            } else if (this.begin[this.begin.length - 1] < num && this.end[this.begin.length - 1] >= num) {
                return this.prov[this.begin.length - 1];
            }
        }
        return -1;
    }
}

