/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.services.identify.range;

import java.io.File;
import java.util.Arrays;
import ru.softlogic.services.identify.range.BaseRangeIdentifier;
import ru.softlogic.services.identify.range.Range;
import ru.softlogic.services.identify.range.RangeComparator;

class RangeIdentifier
extends BaseRangeIdentifier {
    private Range[] ranges;
    private boolean loaded;

    public RangeIdentifier(File dir) {
        super(dir);
    }

    @Override
    protected void onHeader(int count) {
        this.ranges = new Range[count];
    }

    @Override
    protected void onRecord(int index, String begin, String end, short operator) {
        this.ranges[index] = new Range(Integer.parseInt(begin), Integer.parseInt(end), operator);
    }

    @Override
    protected void onError() {
        this.ranges = null;
        this.loaded = false;
    }

    @Override
    protected void onSuccess() {
        this.loaded = true;
    }

    @Override
    public short getOperator(String number) {
        int num;
        int index;
        if (this.loaded && this.ranges != null && (index = Arrays.binarySearch(this.ranges, new Range(num = Integer.parseInt(number), num, 0), new RangeComparator())) >= 0) {
            return this.ranges[index].getService();
        }
        return -1;
    }
}

