/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.services.identify.range;

class Range {
    private final int begin;
    private final int end;
    private final short service;

    public Range(int begin, int end, short service) {
        if (begin < 0 || end < 0 || service < 0) {
            throw new IllegalArgumentException("Parameters must be positive");
        }
        if (begin > end) {
            throw new IllegalArgumentException("Begin must be ");
        }
        this.begin = begin;
        this.end = end;
        this.service = service;
    }

    public boolean isNumber() {
        return this.begin == this.end;
    }

    public boolean include(Range oth) {
        return this.begin <= oth.begin && this.end >= oth.getEnd();
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public short getService() {
        return this.service;
    }

    public String toString() {
        return "Range{begin=" + this.begin + ", end=" + this.end + ", service=" + this.service + '}';
    }
}

