/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.services.identify.range;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import ru.softlogic.input.model.utils.FileUtil;
import ru.softlogic.services.identify.IdentifyUtil;
import ru.softlogic.services.identify.MobileIdentifier;

abstract class BaseRangeIdentifier
implements MobileIdentifier {
    private final File dir;

    public BaseRangeIdentifier(File dir) {
        this.dir = dir;
    }

    @Override
    public void load() throws IOException {
        BufferedReader br = null;
        try {
            br = IdentifyUtil.getBufferedReader(this.dir, "capacity.csv");
            String line = br.readLine();
            if (line == null || !line.matches("\\d+")) {
                throw new IOException("Wrong header, record count must be numeric");
            }
            this.onHeader(Integer.parseInt(line));
            int i = 0;
            while ((line = br.readLine()) != null) {
                String[] params = line.split(":");
                this.onRecord(i++, params[0], params[1], Short.parseShort(params[2]));
            }
            this.onSuccess();
        }
        catch (IOException ex) {
            try {
                this.onError();
                throw ex;
            }
            catch (Throwable throwable) {
                FileUtil.close((Closeable[])new Closeable[]{br});
                throw throwable;
            }
        }
        FileUtil.close((Closeable[])new Closeable[]{br});
    }

    protected abstract void onHeader(int var1);

    protected abstract void onRecord(int var1, String var2, String var3, short var4);

    protected abstract void onError();

    protected abstract void onSuccess();

    protected void onFinish() {
    }
}

