/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.text.Formatter;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.TextField;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.parser.FormFieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.factory.KeyboardFactory;
import ru.softlogic.parser.factory.filter.FilterFactory;
import ru.softlogic.parser.factory.formatter.FormatterFactory;
import ru.softlogic.parser.factory.modificator.ModificatorFactory;
import ru.softlogic.parser.factory.validator.ValidatorCreatingException;
import ru.softlogic.parser.factory.validator.ValidatorFactory;
import ru.softlogic.parser.uni.v2.FormFieldParser;
import ru.softlogic.parser.uni.v2.FormParserContext;
import ru.softlogic.parser.uni.v2.FormParserW3C;

@FormFieldAnnotation(name="text-field")
class TextFieldParser
extends FormFieldParser {
    TextFieldParser() {
    }

    @Override
    public List<? extends IdentityField> parse(FormParserContext parserContext, Element element) throws ParseException {
        try {
            TextField tf = new TextField();
            this.prefillField((IdentityField)tf, element);
            tf.setDefaultValue(TextFieldParser.getAttribute(element, "default"));
            tf.setExampleValue(TextFieldParser.getAttribute(element, "example"));
            tf.setPrefix(TextFieldParser.getAttribute(element, "prefix"));
            tf.setPostfix(TextFieldParser.getAttribute(element, "postfix"));
            tf.setMaxLength(this.getMaxLen(element, tf.getId(), FormParserW3C.getParams()));
            tf.setSecure(Boolean.parseBoolean(TextFieldParser.getAttribute(element, "secure")));
            tf.setReadOnly(Boolean.parseBoolean(TextFieldParser.getAttribute(element, "read-only")));
            tf.setFailRegex(TextFieldParser.getAttribute(element, "fail-regex"));
            tf.setKeyboard(KeyboardFactory.createUni(element));
            tf.setFlags(this.getFlags(element));
            tf.setIcon(TextFieldParser.getAttribute(element, "icon"));
            Element splitEl = TextFieldParser.getElement(element, "split");
            Element splitDataEl = TextFieldParser.getElement(element, "split-data");
            Element filterSection = TextFieldParser.getElement(element, "filter");
            Formatter frm = FormatterFactory.createUni(splitEl);
            if (frm != null) {
                tf.setFormatter(frm);
            }
            if ((frm = FormatterFactory.createUni(splitDataEl)) != null) {
                tf.setDataFormatter(frm);
            }
            tf.setFilter(FilterFactory.createUni(filterSection));
            tf.setValidator(this.getValidator(element, tf.getId()));
            Element modifEl = TextFieldParser.getElement(element, "replaces");
            Modificator modificator = ModificatorFactory.createUni(modifEl);
            if (modificator != null) {
                tf.setModificator(modificator);
            } else {
                tf.setModificator((Modificator)new VoidModificator());
            }
            return Collections.singletonList(tf);
        }
        catch (NumberFormatException ex) {
            throw new ParseException(ex);
        }
    }

    private Validator getValidator(Element element, String name) throws ParseException {
        try {
            Element verify = TextFieldParser.getElement(element, "verify");
            Validator validator = ValidatorFactory.createUni(verify);
            return this.checkValidator(validator, name, FormParserW3C.getParams());
        }
        catch (ValidatorCreatingException ex) {
            throw new ParseException(ex);
        }
    }
}

