/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.parser.uni.v2.AutocompleteFieldParser;
import ru.softlogic.parser.uni.v2.CheckBoxFieldParser;
import ru.softlogic.parser.uni.v2.CommisionConfirmScreen;
import ru.softlogic.parser.uni.v2.DateFieldParser;
import ru.softlogic.parser.uni.v2.ElementSearcherEngine;
import ru.softlogic.parser.uni.v2.FormElementParser;
import ru.softlogic.parser.uni.v2.FormFieldParser;
import ru.softlogic.parser.uni.v2.FormScreenParser;
import ru.softlogic.parser.uni.v2.GroupScreen;
import ru.softlogic.parser.uni.v2.ImageSelectorScreen;
import ru.softlogic.parser.uni.v2.InfoScreen;
import ru.softlogic.parser.uni.v2.NumericFieldParser;
import ru.softlogic.parser.uni.v2.NumericScreen;
import ru.softlogic.parser.uni.v2.PlaceholderParser;
import ru.softlogic.parser.uni.v2.PopupScreen;
import ru.softlogic.parser.uni.v2.RowFieldParser;
import ru.softlogic.parser.uni.v2.RowScreen;
import ru.softlogic.parser.uni.v2.SelectorFieldParser;
import ru.softlogic.parser.uni.v2.SetScreen;
import ru.softlogic.parser.uni.v2.TableScreen;
import ru.softlogic.parser.uni.v2.TextFieldParser;
import ru.softlogic.parser.uni.v2.TextScreen;
import ru.softlogic.parser.uni.v2.TextSelectorScreen;

class StaticElementSearcherEngine
implements ElementSearcherEngine {
    private final Map<String, FormScreenParser> screens;
    private final Map<String, FormFieldParser> fields;
    private final Map<String, FormElementParser> elements;

    public StaticElementSearcherEngine() {
        HashMap<String, FormScreenParser> s = new HashMap<String, FormScreenParser>();
        s.put("info-field", new InfoScreen());
        s.put("text-selector", new TextSelectorScreen());
        s.put("commission-confirm", new CommisionConfirmScreen());
        s.put("text-field", new TextScreen());
        s.put("numeric-field", new NumericScreen());
        s.put("popup-field", new PopupScreen());
        s.put("row", new RowScreen());
        s.put("group-field", new GroupScreen());
        s.put("image-selector", new ImageSelectorScreen());
        s.put("table-field", new TableScreen());
        this.screens = Collections.unmodifiableMap(s);
        HashMap<String, SetScreen> e = new HashMap<String, SetScreen>();
        e.put("set-field", new SetScreen());
        this.elements = Collections.unmodifiableMap(e);
        HashMap<String, FormFieldParser> f = new HashMap<String, FormFieldParser>();
        f.put("checkbox-field", new CheckBoxFieldParser());
        f.put("text-selector", new SelectorFieldParser());
        f.put("text-field", new TextFieldParser());
        f.put("numeric-field", new NumericFieldParser());
        f.put("autocomplete-field", new AutocompleteFieldParser());
        f.put("placeholder", new PlaceholderParser());
        f.put("row", new RowFieldParser());
        f.put("date-field", new DateFieldParser());
        this.fields = Collections.unmodifiableMap(f);
    }

    @Override
    public Map<String, FormScreenParser> getAllFormScreens() {
        return this.screens;
    }

    @Override
    public Map<String, FormFieldParser> getAllFormFields() {
        return this.fields;
    }

    @Override
    public Map<String, FormElementParser> getAllFormElements() {
        return this.elements;
    }
}

