/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.RowParams;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.parser.FormFieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.v2.FormFieldParser;
import ru.softlogic.parser.uni.v2.FormParserContext;
import ru.softlogic.parser.uni.v2.FormParserHelper;
import ru.softlogic.parser.uni.v2.FormParserW3C;

@FormFieldAnnotation(name="row")
class RowFieldParser
extends FormFieldParser {
    RowFieldParser() {
    }

    public List<IdentityField> parse(FormParserContext parserContext, Element element) throws ParseException {
        ArrayList<IdentityField> fields = new ArrayList<IdentityField>();
        StringBuilder rowId = new StringBuilder();
        int totalWidth = 0;
        int widthSetCount = 0;
        List<Element> childElements = RowFieldParser.getChildElements(element);
        for (Element field : childElements) {
            IdentityField identityField = FormParserHelper.getFieldByName(parserContext, field).get(0);
            rowId.append(identityField.getId());
            fields.add(identityField);
            if (identityField.getWidth() == 0) continue;
            totalWidth += identityField.getWidth();
            ++widthSetCount;
        }
        if (totalWidth > 100) {
            throw new ParseException("Width exceeds 100 percent");
        }
        if (totalWidth == 100 && widthSetCount < childElements.size()) {
            throw new ParseException("Some items can not be placed. The entire width of the occupied");
        }
        int avgWidth = 0;
        if (childElements.size() != widthSetCount) {
            avgWidth = (100 - totalWidth) / (childElements.size() - widthSetCount);
        }
        String rowName = rowId.toString();
        for (IdentityField field : fields) {
            field.setRowId(rowName);
            if (field.getWidth() != 0 || avgWidth == 0) continue;
            field.setWidth(avgWidth);
        }
        FormParserW3C.getRowParamsMap().put(rowName, new RowParams(this.getOrientation(element)));
        return fields;
    }
}

