/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.numeric.NumericField;
import ru.softlogic.input.model.field.numeric.Range;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.NumericExternalValidator;
import ru.softlogic.input.model.field.text.NumericRangeValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFilter;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.parser.FormFieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.v2.FormFieldParser;
import ru.softlogic.parser.uni.v2.FormParserContext;

@FormFieldAnnotation(name="numeric-field")
class NumericFieldParser
extends FormFieldParser {
    NumericFieldParser() {
    }

    @Override
    public List<? extends IdentityField> parse(FormParserContext parserContext, Element element) throws ParseException {
        NumericExternalValidator validator;
        NumericField nf = new NumericField();
        this.prefillField((IdentityField)nf, element);
        if (this.getBooleanValue(element, "change-sumdonate")) {
            nf.setId("#sum-donate");
            validator = new NumericExternalValidator();
        } else if (this.getBooleanValue(element, "change-sumpurchase")) {
            nf.setId("#sum");
            validator = new NumericExternalValidator();
        } else if (this.getBooleanValue(element, "change-sumexchange")) {
            validator = new NumericExternalValidator();
        } else {
            LinkedList<Range> ranges = new LinkedList<Range>();
            String min = NumericFieldParser.getAttribute(element, "min");
            String max = NumericFieldParser.getAttribute(element, "max");
            ranges.add(new Range(Float.valueOf(min).floatValue(), Float.valueOf(max).floatValue()));
            validator = new NumericRangeValidator(ranges);
        }
        nf.setValidator((Validator)validator);
        nf.setDefaultValue(NumericFieldParser.getAttribute(element, "default"));
        nf.setExampleValue(NumericFieldParser.getAttribute(element, "example"));
        nf.setUnitCount(5);
        nf.setDecimalCount(2);
        nf.setModificator((Modificator)new VoidModificator());
        nf.setFilter((Filter)new VoidFilter());
        nf.setFlags(this.getFlags(element));
        boolean allowDecimal = this.getBooleanValue(element, "allow-decimal");
        nf.setKeyboard(new Keyboard(KeyboardType.Digital, allowDecimal ? Character.valueOf('.') : null));
        String ud = NumericFieldParser.getAttribute(element, "updown");
        nf.setUpdown(ud != null ? Double.parseDouble(ud) : 0.0);
        return Collections.singletonList(nf);
    }

    private boolean getBooleanValue(Element el, String name) {
        return "true".equals(NumericFieldParser.getAttribute(el, name));
    }
}

