/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ru.softlogic.input.model.RowParams;
import ru.softlogic.input.model.advanced.PaymentParams;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.input.model.field.ScreenSequence;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.input.model.screen.ButtonInit;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.input.model.screen.description.SumScreenDescription;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.decrypt.DecryptUtils;
import ru.softlogic.parser.uni.FormParser;
import ru.softlogic.parser.uni.v2.FormParserContext;
import ru.softlogic.parser.uni.v2.FormParserHelper;

public class FormParserW3C
extends BaseElementParser
implements FormParser {
    private static final Map<String, RowParams> rowParamsMap = new HashMap<String, RowParams>();
    private static volatile int params = 16;

    @Override
    public void setParams(int params) {
        FormParserW3C.params = params;
    }

    public static int getParams() {
        return params;
    }

    @Deprecated
    public static Map<String, RowParams> getRowParamsMap() {
        return rowParamsMap;
    }

    @Override
    public Form getForm(File file, String serviceId, File resourceDir) throws ParseException {
        try {
            return this.readForm(this.getInputStream(file), serviceId, resourceDir);
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
    }

    @Override
    public Form getForm(InputStream source, String serviceId, File resourceDir) throws ParseException {
        return this.readForm(source, serviceId, resourceDir);
    }

    @Override
    public Form getForm(String source, String serviceId, File resourceDir) throws ParseException {
        return this.readForm(new ByteArrayInputStream(source.getBytes()), serviceId, resourceDir);
    }

    public List<Integer> getServices(File file) throws ParseException {
        ArrayList<Integer> result = new ArrayList<Integer>();
        try {
            Document document = FormParserW3C.getDocument(this.getInputStream(file));
            NodeList nl = FormParserW3C.execXPath(document, "//*[local-name() = 'form']");
            for (int i = 0; i < nl.getLength(); ++i) {
                Element item = (Element)nl.item(i);
                String serviceId = item.getAttribute("service-id");
                result.add(Integer.parseInt(serviceId));
            }
        }
        catch (XPathExpressionException ex) {
            throw new ParseException(ex);
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
        return result;
    }

    private Form readForm(InputStream stream, String serviceId, File resourceDir) throws ParseException {
        try {
            Document document = FormParserW3C.getDocument(stream);
            NodeList nl = FormParserW3C.execXPath(document, "//*[local-name() = 'form'][@service-id='" + serviceId + "']");
            switch (nl.getLength()) {
                case 0: {
                    throw new ParseException("Form not found");
                }
                case 1: {
                    return this.loadFormFromElements((Element)nl.item(0), resourceDir);
                }
            }
            throw new ParseException("Too many forms found. Count=" + nl.getLength() + ". Service id" + serviceId);
        }
        catch (XPathExpressionException th) {
            throw new ParseException(th);
        }
    }

    private static Document getDocument(InputStream source) throws ParseException {
        try {
            return FormParserW3C.createDocumentBuilder().parse(source);
        }
        catch (ParserConfigurationException ex) {
            throw new ParseException(ex);
        }
        catch (SAXException ex) {
            throw new ParseException(ex);
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
    }

    private InputStream getInputStream(File file) throws IOException {
        InputStream fis;
        if (file.getAbsolutePath().endsWith(".enc")) {
            String password = RuntimeConfiguration.getInstance().getPassword();
            fis = this.openGZIPInputStream(DecryptUtils.decrypt(file, password));
        } else {
            fis = file.getAbsolutePath().endsWith(".gz") ? this.openGZIPInputStream(new FileInputStream(file)) : new FileInputStream(file);
        }
        return new BufferedInputStream(fis);
    }

    private GZIPInputStream openGZIPInputStream(InputStream stream) throws IOException {
        try {
            return new GZIPInputStream(stream);
        }
        catch (IOException ex) {
            stream.close();
            throw ex;
        }
    }

    private static synchronized DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        if ((params & 0x100) == 0) {
            try {
                dbFactory.setXIncludeAware(true);
                dbFactory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        dbFactory.setNamespaceAware(true);
        return dbFactory.newDocumentBuilder();
    }

    @Override
    public Map<Integer, Form> loadAllForms(File formFile, File resourceDir) throws ParseException {
        try {
            return this.readForm(new FileInputStream(formFile), resourceDir);
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
    }

    @Override
    public Map<Integer, Form> loadAllFormsFromDir(File formsDir, File resourceDir) throws ParseException {
        try {
            HashMap<Integer, Form> allForms = new HashMap<Integer, Form>();
            for (File formFile : this.getFiles(formsDir)) {
                allForms.putAll(this.readForm(new FileInputStream(formFile), resourceDir));
            }
            return allForms;
        }
        catch (IOException ex) {
            throw new ParseException(ex);
        }
    }

    private List<File> getFiles(File formsFolder) {
        File[] array = formsFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                String name = file.getName();
                return file.isFile() && ("forms.xml".equalsIgnoreCase(name) || name.matches("[0-9x]{1,4}\\.xml"));
            }
        });
        Arrays.sort(array, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o2.getName().compareTo(o1.getName());
            }
        });
        return Arrays.asList(array);
    }

    private Map<Integer, Form> readForm(InputStream stream, File resourceDir) throws ParseException {
        try {
            Document document = FormParserW3C.getDocument(stream);
            NodeList nl = FormParserW3C.execXPath(document, "//*[local-name() = 'form']");
            if (nl.getLength() == 0) {
                throw new ParseException("Form not found");
            }
            HashMap<Integer, Form> forms = new HashMap<Integer, Form>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Element elForm = (Element)nl.item(i);
                Form form = this.loadFormFromElements(elForm, resourceDir);
                String serviceId = elForm.getAttribute("service-id");
                forms.put(Integer.parseInt(serviceId), form);
            }
            return forms;
        }
        catch (XPathExpressionException th) {
            throw new ParseException(th);
        }
    }

    private Form loadFormFromElements(Element elForm, File resourceDir) throws ParseException {
        try {
            FormParserContext parserContext = new FormParserContext();
            parserContext.setResourceDir(resourceDir);
            ArrayList<String> paramList = new ArrayList<String>();
            String redirectParamsAttr = FormParserW3C.getAttribute(elForm, "redirect-params");
            if (redirectParamsAttr != null && !redirectParamsAttr.trim().isEmpty()) {
                for (String str : redirectParamsAttr.trim().split(",")) {
                    paramList.add(str.trim());
                }
            }
            parserContext.setRedirectParams(paramList);
            String attrChangeNumber = FormParserW3C.getAttribute(elForm, "chnum-name");
            String attrConfirmSound = FormParserW3C.getAttribute(elForm, "confirm-sound");
            ScreenSequence ss = FormParserHelper.parceLayer(parserContext, elForm);
            Element dem = FormParserW3C.getElement(elForm, "send-request");
            String demandMessage = FormParserW3C.getAttribute(dem, "message");
            String sumScreen = FormParserW3C.getAttribute(elForm, "sum");
            String sumScreenElement = FormParserW3C.getAttribute(elForm, "sum-view");
            String confirmScreen = FormParserW3C.getAttribute(elForm, "confirm-screen");
            SumScreenDescription ssd = new SumScreenDescription();
            ssd.setType(sumScreen == null ? "sum" : sumScreen);
            ssd.setTitle(sumScreenElement == null ? "id1" : sumScreenElement);
            ssd.setScreenTitle(sumScreenElement == null ? "id1" : sumScreenElement);
            HashMap<String, ButtonInit> buttons = new HashMap<String, ButtonInit>();
            buttons.put("next", new ButtonInit(null));
            buttons.put("cbc", new ButtonInit(null));
            buttons.put("prev", new ButtonInit(null));
            buttons.put("exit", new ButtonInit(null));
            ssd.setButtons(buttons);
            String minSumLimit = FormParserW3C.getAttribute(elForm, "min-sum-limit");
            String maxSumLimit = FormParserW3C.getAttribute(elForm, "max-sum-limit");
            PaymentParams paymentParams = new PaymentParams();
            String singleCheck = FormParserW3C.getAttribute(elForm, "single-check");
            paymentParams.setSingleCheck(Boolean.parseBoolean(singleCheck));
            String allowReturn = FormParserW3C.getAttribute(elForm, "allow-return");
            paymentParams.setAllowReturn(Boolean.parseBoolean(allowReturn));
            Form form = new Form(ss, demandMessage, (ScreenDescription)ssd, confirmScreen, minSumLimit, maxSumLimit, paymentParams);
            form.setPrefillItem(this.loadPrefillItems(elForm));
            form.setConfirmSound(attrConfirmSound);
            form.setChangeNumber(attrChangeNumber);
            form.setRowParams(rowParamsMap.isEmpty() ? null : rowParamsMap);
            return form;
        }
        catch (Exception th) {
            throw new ParseException(th);
        }
    }

    private static synchronized NodeList execXPath(Document doc, String xPathStr) throws XPathExpressionException {
        XPath xPath = XPathFactory.newInstance().newXPath();
        return (NodeList)xPath.evaluate(xPathStr, doc, XPathConstants.NODESET);
    }
}

