/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.ScreenSequence;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.v2.ElementSearcher;
import ru.softlogic.parser.uni.v2.FormElementParser;
import ru.softlogic.parser.uni.v2.FormFieldParser;
import ru.softlogic.parser.uni.v2.FormParserContext;
import ru.softlogic.parser.uni.v2.FormScreenParser;

public final class FormParserHelper
extends BaseElementParser {
    private static final List<String> ignoreList = new ArrayList<String>();

    private FormParserHelper() {
    }

    public static List<? extends IdentityField> getFieldByName(FormParserContext parserContext, Element field) throws ParseException {
        String name = field.getTagName();
        FormFieldParser fieldParser = ElementSearcher.getAllFormFields().get(name);
        return fieldParser.parse(parserContext, field);
    }

    public static ScreenDescription getScreenByName(FormParserContext parserContext, Element field) throws ParseException {
        String name = field.getTagName();
        FormScreenParser screenParser = ElementSearcher.getAllFormScreens().get(name);
        if (screenParser == null) {
            return null;
        }
        return screenParser.parse(parserContext, field);
    }

    public static InputElement getElementByName(FormParserContext parserContext, Element field) throws ParseException {
        String name = field.getTagName();
        FormElementParser elemParser = ElementSearcher.getAllFormElements().get(name);
        if (elemParser == null) {
            return null;
        }
        return elemParser.parse(parserContext, field);
    }

    public static ScreenSequence parceLayer(FormParserContext parserContext, Element list) throws ParseException {
        LinkedList<ScreenDescription> result = new LinkedList<ScreenDescription>();
        LinkedList<InputElement> elements = new LinkedList<InputElement>();
        for (Element field : FormParserHelper.getChildElements(list)) {
            if (FormParserHelper.containedInIgnoreList(field)) continue;
            ScreenDescription screenByName = FormParserHelper.getScreenByName(parserContext, field);
            if (screenByName != null) {
                result.add(screenByName);
                continue;
            }
            InputElement ie = FormParserHelper.getElementByName(parserContext, field);
            if (ie == null) {
                throw new ParseException("Unknown element: " + field.getTagName());
            }
            elements.add(ie);
        }
        if (!result.isEmpty() || !elements.isEmpty()) {
            return new ScreenSequence(result, elements);
        }
        return null;
    }

    private static boolean containedInIgnoreList(Element field) {
        return ignoreList.contains(field.getTagName());
    }

    static {
        ignoreList.add("prefill-items");
        ignoreList.add("send-request");
    }
}

