/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.softlogic.parser.DynamicParseElementSearcher;
import ru.softlogic.parser.FormElementAnnotation;
import ru.softlogic.parser.FormFieldAnnotation;
import ru.softlogic.parser.FormScreenAnnotation;
import ru.softlogic.parser.uni.v2.FormElementParser;
import ru.softlogic.parser.uni.v2.FormFieldParser;
import ru.softlogic.parser.uni.v2.FormScreenParser;

public class DynamicElementSearcherEngine
extends DynamicParseElementSearcher {
    private static final Logger log = LoggerFactory.getLogger((String)"pay");

    public static Map<String, FormScreenParser> getAllFormScreens() {
        List<Class> l = DynamicElementSearcherEngine.getClasses();
        HashMap<String, FormScreenParser> map = new HashMap<String, FormScreenParser>();
        for (Class cl : l) {
            if (!cl.isAnnotationPresent(FormScreenAnnotation.class)) continue;
            try {
                FormScreenAnnotation annotation = cl.getAnnotation(FormScreenAnnotation.class);
                FormScreenParser ps = (FormScreenParser)cl.newInstance();
                map.put(annotation.name(), ps);
            }
            catch (Exception ex) {
                log.warn("ElementSearcher.getAllFormScreens", (Throwable)ex);
            }
        }
        DynamicElementSearcherEngine.printMap("Form screen map: ", map);
        return map;
    }

    public static Map<String, FormFieldParser> getAllFormFields() {
        List<Class> l = DynamicElementSearcherEngine.getClasses();
        HashMap<String, FormFieldParser> map = new HashMap<String, FormFieldParser>();
        for (Class cl : l) {
            if (!cl.isAnnotationPresent(FormFieldAnnotation.class)) continue;
            try {
                FormFieldAnnotation annotation = cl.getAnnotation(FormFieldAnnotation.class);
                FormFieldParser ps = (FormFieldParser)cl.newInstance();
                map.put(annotation.name(), ps);
            }
            catch (Exception ex) {
                log.warn("ElementSearcher.getAllFormFields", (Throwable)ex);
            }
        }
        DynamicElementSearcherEngine.printMap("Form field map: ", map);
        return map;
    }

    public static Map<String, FormElementParser> getAllFormElements() {
        List<Class> l = DynamicElementSearcherEngine.getClasses();
        HashMap<String, FormElementParser> map = new HashMap<String, FormElementParser>();
        for (Class cl : l) {
            if (!cl.isAnnotationPresent(FormElementAnnotation.class)) continue;
            try {
                FormElementAnnotation annotation = cl.getAnnotation(FormElementAnnotation.class);
                FormElementParser ps = (FormElementParser)cl.newInstance();
                map.put(annotation.name(), ps);
            }
            catch (Exception ex) {
                log.warn("ElementSearcher.getAllFormElements", (Throwable)ex);
            }
        }
        DynamicElementSearcherEngine.printMap("Form element map: ", map);
        return map;
    }
}

