/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.checkbox.CheckBoxField;
import ru.softlogic.parser.FormFieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.uni.v2.FormFieldParser;
import ru.softlogic.parser.uni.v2.FormParserContext;

@FormFieldAnnotation(name="checkbox-field")
public class CheckBoxFieldParser
extends FormFieldParser {
    @Override
    public List<? extends IdentityField> parse(FormParserContext parserContext, Element element) throws ParseException {
        CheckBoxField cbf = new CheckBoxField();
        this.prefillField((IdentityField)cbf, element);
        cbf.setDefaultValue(CheckBoxFieldParser.getAttribute(element, "default"));
        cbf.setReadOnly(Boolean.parseBoolean(CheckBoxFieldParser.getAttribute(element, "read-only")));
        cbf.setMessageOff(CheckBoxFieldParser.getAttribute(element, "message-off"));
        cbf.setMessageOffId(CheckBoxFieldParser.getAttribute(element, "message-off-id"));
        cbf.setText(CheckBoxFieldParser.getAttribute(element, "text"));
        cbf.setHelpOff(this.getHelp(element, "help-off"));
        cbf.setHelpOffId(this.getHelpOffId(element));
        cbf.setRequired(!"false".equalsIgnoreCase(CheckBoxFieldParser.getAttribute(element, "required")));
        cbf.setFlags(this.getFlags(element));
        return Collections.singletonList(cbf);
    }

    private String getHelpOffId(Element element) {
        Element help = CheckBoxFieldParser.getElement(element, "help-off");
        if (help != null) {
            return CheckBoxFieldParser.getAttribute(help, "id");
        }
        return null;
    }
}

