/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni.v2;

import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;
import ru.softlogic.input.model.field.autocomplete.DataStore;
import ru.softlogic.parser.FormFieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.factory.KeyboardFactory;
import ru.softlogic.parser.factory.autocomplete.AutocompleteDataStoreFactory;
import ru.softlogic.parser.uni.v2.FormFieldParser;
import ru.softlogic.parser.uni.v2.FormParserContext;

@FormFieldAnnotation(name="autocomplete-field")
class AutocompleteFieldParser
extends FormFieldParser {
    AutocompleteFieldParser() {
    }

    @Override
    public List<? extends IdentityField> parse(FormParserContext parserContext, Element element) throws ParseException {
        AutoCompleteField acf = new AutoCompleteField();
        this.prefillField((IdentityField)acf, element);
        acf.setKeyboard(KeyboardFactory.createUni(element));
        acf.setOptional(Boolean.parseBoolean(AutocompleteFieldParser.getAttribute(element, "optional")));
        acf.setAllowCustom(Boolean.parseBoolean(AutocompleteFieldParser.getAttribute(element, "allow-custom")));
        acf.setExampleValue(AutocompleteFieldParser.getAttribute(element, "example"));
        String minchars = AutocompleteFieldParser.getAttribute(element, "min-chars");
        String maxitems = AutocompleteFieldParser.getAttribute(element, "max-items");
        acf.setMinChars(Integer.parseInt(minchars));
        acf.setMaxItems(Integer.parseInt(maxitems));
        Element dsSection = AutocompleteFieldParser.getElement(element, "data-source");
        DataStore ds = AutocompleteDataStoreFactory.create(dsSection);
        acf.setDataStore(ds);
        acf.setFlags(this.getFlags(element));
        return Collections.singletonList(acf);
    }
}

