/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.uni;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.softlogic.input.model.form.Form;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ParserUtility;
import ru.softlogic.parser.Store;
import ru.softlogic.parser.uni.FormNotFoundException;
import ru.softlogic.parser.uni.Parser;

public class FormStore
implements Store {
    private static final Logger log = LoggerFactory.getLogger((String)"pay");
    private final File formDir;
    private final File dsDir;
    private final Map<String, SoftReference<Form>> forms = new HashMap<String, SoftReference<Form>>();
    private String password;

    public FormStore(File formDir, File dataSourcePath) {
        if (formDir == null) {
            throw new NullPointerException("Form dir is not set");
        }
        if (dataSourcePath == null) {
            throw new NullPointerException("Data source dir is not set");
        }
        if (log == null) {
            throw new NullPointerException("Logger is null");
        }
        this.formDir = formDir;
        this.dsDir = dataSourcePath;
    }

    public synchronized Form getForm(short code, Locale locale, String password) throws FormNotFoundException {
        this.password = password;
        return this.getForm(code, locale);
    }

    public synchronized Form getForm(short code, Locale locale) throws FormNotFoundException {
        Form form;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        log.debug("Cache: {}", this.forms);
        if (this.password != null) {
            form = this.getForm(code, "_" + locale.getLanguage() + ".enc");
            if (form != null) {
                return form;
            }
            form = this.getForm(code, ".enc");
            if (form != null) {
                return form;
            }
        }
        if ((form = this.getForm(code, "_" + locale.getLanguage() + ".xml")) != null) {
            return form;
        }
        form = this.getForm(code, ".xml");
        if (form != null) {
            return form;
        }
        throw new FormNotFoundException("Form for service " + code + " is not found");
    }

    @Override
    public synchronized void clear() {
        this.forms.clear();
    }

    private Form getForm(short code, String suffix) {
        String id = Short.toString(code) + suffix;
        log.debug("Search: {}", (Object)id);
        if (!ParserUtility.isUniCacheUse()) {
            this.forms.clear();
        }
        if (this.forms.containsKey(id)) {
            SoftReference<Form> srf = this.forms.get(id);
            if (srf != null) {
                Form f = srf.get();
                if (f == null) {
                    log.debug("SoftReference go out: {}", (Object)(code + suffix));
                    f = this.readFormRes(code, suffix);
                    this.forms.put(id, new SoftReference<Form>(f));
                }
                return f;
            }
        } else {
            log.debug("Create form : {}", (Object)id);
            Form f = this.readFormRes(code, suffix);
            if (f != null) {
                this.forms.put(id, new SoftReference<Form>(f));
                return f;
            }
            this.forms.put(id, null);
        }
        return null;
    }

    private Form readFormRes(short code, String postfix) {
        log.info("Getting form for service id: {}", (Object)code);
        Form form = this.tryLoad(new File(this.formDir, code + postfix), code);
        if (form != null) {
            return form;
        }
        form = this.tryLoad(new File(this.formDir, code / 100 + "xx" + postfix), code);
        if (form != null) {
            return form;
        }
        return this.tryLoad(new File(this.formDir, "/forms" + postfix), code);
    }

    private Form tryLoad(File file, short code) {
        if (file.isFile()) {
            try {
                log.info("Load form from: {}", (Object)file.getAbsolutePath());
                return Parser.getForm(file, code, new File(this.dsDir, Short.toString(code) + "/"));
            }
            catch (ParseException ex) {
                log.error("Error on parsing form", (Throwable)ex);
            }
        }
        return null;
    }
}

