/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.mob;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ru.softlogic.parser.mob.CityProfile;
import ru.softlogic.parser.mob.LocalCapacityElement;

public class LocalNumberExtractor {
    private static final Logger log = LoggerFactory.getLogger((String)"pay");
    private final File file;
    private Map<String, CityProfile> map;
    private final CityProfile voidProfile;

    public LocalNumberExtractor(File file) {
        this.file = file;
        this.voidProfile = new CityProfile("", new LocalCapacityElement[0]);
    }

    public CityProfile getCityProfile(String cityCode) {
        this.load();
        CityProfile profile = this.map.get(cityCode);
        if (profile != null) {
            return profile;
        }
        return this.voidProfile;
    }

    private void load() {
        if (this.map != null) {
            return;
        }
        this.map = new HashMap<String, CityProfile>();
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(this.file);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            NodeList nl = root.getElementsByTagName("city");
            if (nl == null || nl.getLength() == 0) {
                return;
            }
            for (int i = 0; i < nl.getLength(); ++i) {
                Element element = (Element)nl.item(i);
                String code = element.getAttribute("code");
                String split = element.getAttribute("mask");
                NodeList items = element.getElementsByTagName("i");
                LocalCapacityElement[] elements = new LocalCapacityElement[items.getLength()];
                for (int j = 0; j < items.getLength(); ++j) {
                    Element item = (Element)items.item(j);
                    elements[j] = new LocalCapacityElement(Short.parseShort(item.getAttribute("p")), item.getAttribute("regex"), item.getAttribute("replace"), item.getAttribute("value"));
                }
                this.map.put(code, new CityProfile(split, elements));
            }
        }
        catch (Exception ex) {
            log.error("Load error", (Object)ex.getMessage());
        }
    }
}

