/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.mob;

import java.util.Arrays;
import ru.softlogic.parser.mob.LocalCapacityElement;

public class CityProfile {
    private final String mask;
    private final int maskLen;
    private final LocalCapacityElement[] elements;

    public CityProfile(String mask, LocalCapacityElement[] elements) {
        this.mask = mask;
        this.maskLen = this.getLengthByMask(mask);
        this.elements = elements;
    }

    public String getMask() {
        return this.mask;
    }

    public int getMaskLen() {
        return this.maskLen;
    }

    private int getLengthByMask(String mask) {
        if (mask == null || mask.isEmpty()) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < mask.length(); ++i) {
            if (mask.charAt(i) != '*') continue;
            ++count;
        }
        return count;
    }

    public Short getOperator(String number) {
        if (this.elements == null || this.elements.length == 0) {
            return null;
        }
        if (number == null || number.isEmpty()) {
            return null;
        }
        for (LocalCapacityElement lce : this.elements) {
            if (!number.matches(lce.getReplaceRegex())) continue;
            return lce.getOperator();
        }
        return null;
    }

    public String convertNumber(String number) {
        if (number == null || number.isEmpty() || this.elements == null || this.elements.length == 0) {
            return number;
        }
        for (LocalCapacityElement lce : this.elements) {
            if (!number.matches(lce.getValidateRegex())) continue;
            return number.replaceAll(lce.getReplaceRegex(), lce.getReplaceValue());
        }
        return number;
    }

    public String toString() {
        return "CityProfile{mask=" + this.mask + ", elements=" + Arrays.toString(this.elements) + '}';
    }
}

