/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.factory.validator;

import org.w3c.dom.Element;
import ru.softlogic.input.model.field.text.CbcValidator;
import ru.softlogic.input.model.field.text.EmptyValidator;
import ru.softlogic.input.model.field.text.IbanIso7064Validator;
import ru.softlogic.input.model.field.text.LuhnValidator;
import ru.softlogic.input.model.field.text.Mod11Validator;
import ru.softlogic.input.model.field.text.Mod11v2Validator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoucherValidator;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.factory.validator.AndFactory;
import ru.softlogic.parser.factory.validator.CustomFactory;
import ru.softlogic.parser.factory.validator.JsFactory;
import ru.softlogic.parser.factory.validator.OrFactory;
import ru.softlogic.parser.factory.validator.RangeFactory;
import ru.softlogic.parser.factory.validator.RegexFactory;
import ru.softlogic.parser.factory.validator.ValidatorCreatingException;

public class ValidatorFactory
extends BaseElementParser {
    public static final String REGEX = "regex";
    public static final String LUHN = "luhn";
    public static final String RANGE = "range";
    public static final String OR = "or";
    public static final String AND = "and";
    public static final String CBC = "cbc";
    public static final String VOUCHER = "voucher";
    public static final String JS = "js";
    public static final String EMPTY = "empty";
    public static final String CUSTOM = "custom";
    public static final String MOD11 = "mod11";
    public static final String MOD11v2 = "mod11v2";
    public static final String IBAN = "ibaniso7064";

    public static Validator createUni(Element element) throws ValidatorCreatingException {
        String type = ValidatorFactory.getValidatorType(element);
        if (type == null || REGEX.equals(type)) {
            return new RegexFactory().createUni(element);
        }
        if (RANGE.equals(type)) {
            return new RangeFactory().createUni(element);
        }
        if (OR.equals(type)) {
            return new OrFactory().createUni(element);
        }
        if (AND.equals(type)) {
            return new AndFactory().createUni(element);
        }
        if (JS.equals(type)) {
            return new JsFactory().createUni(element);
        }
        if (CUSTOM.equals(type)) {
            return new CustomFactory().createUni(element);
        }
        return ValidatorFactory.getGenericValidator(type);
    }

    public static Validator createAdv(Element element) throws ValidatorCreatingException {
        String type = ValidatorFactory.getValidatorType(element);
        if (type == null || REGEX.equals(type)) {
            return new RegexFactory().createAdv(element);
        }
        if (RANGE.equals(type)) {
            return new RangeFactory().createAdv(element);
        }
        if (OR.equals(type)) {
            return new OrFactory().createAdv(element);
        }
        if (AND.equals(type)) {
            return new AndFactory().createAdv(element);
        }
        if (JS.equals(type)) {
            return new JsFactory().createAdv(element);
        }
        if (CUSTOM.equals(type)) {
            return new CustomFactory().createAdv(element);
        }
        return ValidatorFactory.getGenericValidator(type);
    }

    private static Validator getGenericValidator(String type) throws ValidatorCreatingException {
        if (EMPTY.equals(type)) {
            return new EmptyValidator();
        }
        if (CBC.equals(type)) {
            return new CbcValidator();
        }
        if (LUHN.equals(type)) {
            return new LuhnValidator();
        }
        if (IBAN.equals(type)) {
            return new IbanIso7064Validator();
        }
        if (MOD11.equals(type)) {
            return new Mod11Validator();
        }
        if (MOD11v2.equals(type)) {
            return new Mod11v2Validator();
        }
        if (VOUCHER.equals(type)) {
            return new VoucherValidator();
        }
        throw new ValidatorCreatingException("Unknown validator type: " + type);
    }

    private static String getValidatorType(Element element) throws ValidatorCreatingException {
        if (element == null) {
            throw new ValidatorCreatingException("Validator is not set");
        }
        return ValidatorFactory.getAttribute(element, "type");
    }
}

