/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.factory.validator;

import org.w3c.dom.Element;
import ru.softlogic.input.model.field.text.JsValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.parser.factory.validator.BaseConcreteFactory;
import ru.softlogic.parser.factory.validator.ValidatorCreatingException;

class JsFactory
extends BaseConcreteFactory {
    JsFactory() {
    }

    @Override
    public Validator createUni(Element element) throws ValidatorCreatingException {
        return this.createJsValidator(element);
    }

    @Override
    public Validator createAdv(Element element) throws ValidatorCreatingException {
        return this.createJsValidator(element);
    }

    private Validator createJsValidator(Element element) throws ValidatorCreatingException {
        try {
            if (element != null && element.getTextContent() != null) {
                String script = element.getTextContent();
                return new JsValidator(script, (JsValidator.JsExceptionListener)new ValidatorListener());
            }
            throw new ValidatorCreatingException("Script not exist");
        }
        catch (Exception ex) {
            throw new ValidatorCreatingException(ex);
        }
    }

    private static final class ValidatorListener
    implements JsValidator.JsExceptionListener {
        private ValidatorListener() {
        }

        public void onError(Throwable throwable) {
            throwable.getStackTrace();
        }
    }
}

