/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.factory.selector;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.Data;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.TransactionSum;
import ru.softlogic.input.model.advanced.actions.simple.Set;
import ru.softlogic.input.model.field.ScreenSequence;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.selector.StaticStore;
import ru.softlogic.input.model.field.selector.custom.RedirectCustomData;
import ru.softlogic.input.model.field.selector.custom.SequenceCustomData;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.v2.actions.SetAction;
import ru.softlogic.parser.factory.selector.ConcreteFactory;
import ru.softlogic.parser.uni.v2.FormParserContext;
import ru.softlogic.parser.uni.v2.FormParserHelper;

public class StaticStoreFactory
extends BaseElementParser
implements ConcreteFactory {
    @Override
    public ItemsStore createUni(FormParserContext parserContext, Element element) throws ParseException {
        LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
        for (Element item : StaticStoreFactory.getChildElements(element)) {
            String redirect;
            if (!"item".equals(item.getTagName())) continue;
            HashMap<String, Object> custom = new HashMap<String, Object>();
            ScreenSequence ss = FormParserHelper.parceLayer(parserContext, item);
            if (ss != null) {
                SequenceCustomData sequenceCustomData = new SequenceCustomData(ss);
                custom.put("#sequence", sequenceCustomData);
            }
            if ((redirect = StaticStoreFactory.getAttribute(item, "redirect")) != null) {
                RedirectCustomData redirectCustomData = new RedirectCustomData(Short.valueOf(Short.parseShort(redirect)), parserContext.getRedirectParams());
                custom.put("#redirect", redirectCustomData);
            }
            String enable = StaticStoreFactory.getAttribute(item, "enable");
            SelectorItem si = new SelectorItem(StaticStoreFactory.getAttribute(item, "text"), StaticStoreFactory.getAttribute(item, "text-id"), StaticStoreFactory.getAttribute(item, "value"), StaticStoreFactory.getAttribute(item, "img"), enable == null ? true : Boolean.parseBoolean(enable));
            si.setCustomData(custom);
            String sum = StaticStoreFactory.getAttribute(item, "sum");
            if (sum != null) {
                Data d = new Data();
                d.setSum(new TransactionSum(Float.parseFloat(sum)));
                si.setData(d);
            }
            items.add(si);
        }
        return new StaticStore(items);
    }

    @Override
    public ItemsStore createAdv(Element element) throws ParseException {
        LinkedList<SelectorItem> items = new LinkedList<SelectorItem>();
        for (Element item : StaticStoreFactory.getElements(element, "item")) {
            SelectorItem si = new SelectorItem();
            si.setImage(StaticStoreFactory.getAttribute(item, "image"));
            si.setTitle(StaticStoreFactory.getAttribute(item, "title"));
            si.setTitleId(StaticStoreFactory.getAttribute(item, "title-id"));
            si.setValue(StaticStoreFactory.getAttribute(item, "value"));
            String sum = StaticStoreFactory.getAttribute(item, "sum");
            List<Element> setElements = StaticStoreFactory.getElements(item, "set");
            Data data = null;
            if (setElements != null && !setElements.isEmpty()) {
                data = new Data();
                SetAction setParser = new SetAction();
                ArrayList<InputElement> elements = new ArrayList<InputElement>();
                for (Element setElement : setElements) {
                    Set setValue = setParser.parse(setElement, null);
                    elements.add(setValue.getElement());
                }
                data.setElements(elements);
            }
            if (sum != null) {
                if (data == null) {
                    data = new Data();
                }
                data.setSum(new TransactionSum(Float.parseFloat(sum)));
            }
            si.setData(data);
            si.setHelpBySoftwareType(this.getHelp(item));
            si.setHelpTplBySoftwateType(this.getHelp(item, "help-template"));
            String enabled = StaticStoreFactory.getAttribute(item, "enabled");
            if (enabled != null) {
                si.setEnable(Boolean.parseBoolean(enabled));
            }
            items.add(si);
        }
        return this.getItemsStore(items);
    }

    protected ItemsStore getItemsStore(List<SelectorItem> items) {
        return new StaticStore(items);
    }
}

