/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.factory.autocomplete;

import org.w3c.dom.Element;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteOrderType;
import ru.softlogic.input.model.field.autocomplete.DataPartial;
import ru.softlogic.input.model.field.autocomplete.DataStore;
import ru.softlogic.input.model.field.autocomplete.NoneDataPartial;
import ru.softlogic.input.model.field.autocomplete.PlainDataStore;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.ParseException;

public class AutocompleteDataStoreFactory
extends BaseElementParser {
    public static final String PLAIN = "plain";

    public static DataStore create(Element element) throws ParseException {
        String type = AutocompleteDataStoreFactory.getAttribute(element, "type");
        if (PLAIN.equals(type)) {
            return AutocompleteDataStoreFactory.createPlainDataStore(element);
        }
        throw new ParseException("Unknown type of data store: " + type);
    }

    public static DataStore createPlainDataStore(Element element) throws ParseException {
        String url = AutocompleteDataStoreFactory.getURL(element);
        String def = AutocompleteDataStoreFactory.getDefault(element);
        String[] filters = AutocompleteDataStoreFactory.getFilter(element);
        AutoCompleteOrderType orderType = AutocompleteDataStoreFactory.getOrderType(element);
        return new PlainDataStore(url, def, (DataPartial)new NoneDataPartial(), filters, orderType);
    }

    private static String getURL(Element element) {
        return AutocompleteDataStoreFactory.getAttribute(element, "url");
    }

    private static String getDefault(Element element) {
        return AutocompleteDataStoreFactory.getAttribute(element, "default");
    }

    private static String[] getFilter(Element element) {
        String filterAttr = AutocompleteDataStoreFactory.getAttribute(element, "filter");
        return filterAttr != null ? filterAttr.split(",") : null;
    }

    private static AutoCompleteOrderType getOrderType(Element element) {
        String order = AutocompleteDataStoreFactory.getAttribute(element, "order");
        if (order == null || order.isEmpty()) {
            return AutoCompleteOrderType.NAME;
        }
        return AutoCompleteOrderType.valueOf((String)order.toUpperCase());
    }
}

