/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.factory;

import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.barcode.BarcodeParser;
import ru.softlogic.input.model.field.barcode.BarcodeScanner;
import ru.softlogic.input.model.field.barcode.BlockInit;
import ru.softlogic.input.model.field.barcode.BlockParser;
import ru.softlogic.input.model.field.barcode.BlockRule;
import ru.softlogic.input.model.field.barcode.RegexInit;
import ru.softlogic.input.model.field.barcode.RegexParser;
import ru.softlogic.input.model.field.barcode.RegexRule;
import ru.softlogic.input.model.field.barcode.mur.ERCParser;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.factory.modificator.ModificatorFactory;

public class BarcodeFactory
extends BaseElementParser {
    public static final String REGEX = "regex";
    public static final String BLOCK = "block";
    public static final String MURMANSK_ERC = "murmansk-erc";

    public static BarcodeScanner createScanner(Element element) throws ParseException {
        if (element == null) {
            return null;
        }
        Element section = BarcodeFactory.getElement(element, "barcode-scanner");
        if (section == null) {
            return null;
        }
        BarcodeScanner scanner = new BarcodeScanner();
        scanner.setOnSuccess(BarcodeFactory.getAttribute(section, "on-success"));
        scanner.setShowError(Boolean.parseBoolean(BarcodeFactory.getAttribute(section, "show-error")));
        scanner.setDisableButtonNext(Boolean.parseBoolean(BarcodeFactory.getAttribute(section, "disable-next")));
        Element parserSection = BarcodeFactory.getNotNullElement(section, "barcode-parser", "Barcode parser is not defined");
        String type = BarcodeFactory.getAttribute(parserSection, "type");
        BarcodeFactory barcodeFactory = new BarcodeFactory();
        if (BLOCK.equals(type)) {
            barcodeFactory.createBlock(scanner, parserSection);
        } else if (REGEX.equals(type)) {
            barcodeFactory.createRegex(scanner, parserSection);
        } else if (MURMANSK_ERC.equals(type)) {
            barcodeFactory.createMurmanskErc(scanner);
        } else {
            throw new ParseException("Barcode parser type is not defined");
        }
        return scanner;
    }

    private void createRegex(BarcodeScanner scanner, Element parserSection) throws ParseException {
        LinkedList<RegexRule> regexRules = new LinkedList<RegexRule>();
        Element rules = BarcodeFactory.getElement(parserSection, "rules");
        List<Element> ruleList = BarcodeFactory.getElements(rules, "rule");
        for (Element rule : ruleList) {
            Element modifEl;
            Modificator modificator;
            String key = BarcodeFactory.getAttribute(rule, "key");
            String title = BarcodeFactory.getAttribute(rule, "title");
            String titleId = BarcodeFactory.getAttribute(rule, "title-id");
            String regex = BarcodeFactory.getAttribute(rule, REGEX);
            RegexRule rRule = new RegexRule(key, title, titleId, regex, this.getFlags(rule));
            rRule.setBind(Boolean.parseBoolean(rule.getAttribute("is-bind")));
            String convertFrom = rule.getAttribute("convert-from");
            String convertTo = rule.getAttribute("convert-to");
            if (!convertFrom.isEmpty()) {
                rRule.setConvertFrom(Integer.valueOf(Integer.parseInt(convertFrom)));
            }
            if (!convertTo.isEmpty()) {
                rRule.setConvertTo(Integer.valueOf(Integer.parseInt(convertTo)));
            }
            if ((modificator = ModificatorFactory.createUni(modifEl = BarcodeFactory.getElement(rule, "modificator"))) != null) {
                rRule.setModificator(ModificatorFactory.createUni(modifEl));
            } else {
                rRule.setModificator((Modificator)new VoidModificator());
            }
            regexRules.add(rRule);
        }
        RegexInit ri = new RegexInit(rules.getAttribute("validate"), regexRules.toArray(new RegexRule[regexRules.size()]));
        scanner.setParser((BarcodeParser)new RegexParser(ri));
    }

    private void createBlock(BarcodeScanner scanner, Element parserSection) throws ParseException {
        Element rules = BarcodeFactory.getElement(parserSection, "rules");
        if (rules != null) {
            List<Element> rulesList = BarcodeFactory.getElements(rules, "rule");
            LinkedList<BlockRule> blockRules = new LinkedList<BlockRule>();
            for (Element rule : rulesList) {
                String key = BarcodeFactory.getAttribute(rule, "key");
                String title = BarcodeFactory.getAttribute(rule, "title");
                String titleId = BarcodeFactory.getAttribute(rule, "title-id");
                int begin = Integer.parseInt(BarcodeFactory.getAttribute(rule, "begin"));
                int end = Integer.parseInt(BarcodeFactory.getAttribute(rule, "end"));
                blockRules.add(new BlockRule(key, title, Integer.valueOf(this.getFlags(rule)), begin, end, titleId));
            }
            BlockInit bi = new BlockInit(blockRules.toArray(new BlockRule[blockRules.size()]));
            BlockParser bp = new BlockParser(bi);
            scanner.setParser((BarcodeParser)bp);
        }
    }

    private void createMurmanskErc(BarcodeScanner scanner) throws ParseException {
        scanner.setParser((BarcodeParser)new ERCParser());
    }
}

