/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.decrypt;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class OpenSSLPBEInputStream
extends InputStream {
    private static final String OPENSSL_HEADER_STRING = "Salted__";
    private static final String OPENSSL_HEADER_ENCODE = "ASCII";
    private static final int READ_BLOCK_SIZE = 65536;
    private static final int SALT_SIZE_BYTES = 8;
    private final Cipher cipher;
    private final InputStream inStream;
    private final byte[] bufferCipher = new byte[65536];
    private byte[] bufferClear = null;
    private int index = Integer.MAX_VALUE;
    private int maxIndex = 0;

    public OpenSSLPBEInputStream(InputStream streamIn, String algIn, int iterationCount, char[] password) throws IOException {
        this.inStream = streamIn;
        try {
            byte[] salt = this.readSalt();
            this.cipher = this.initializeCipher(password, salt, 2, algIn, iterationCount);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int available() throws IOException {
        return this.inStream.available();
    }

    @Override
    public int read() throws IOException {
        if (this.index > this.maxIndex) {
            this.index = 0;
            int read = this.inStream.read(this.bufferCipher);
            if (read != -1) {
                this.bufferClear = this.cipher.update(this.bufferCipher, 0, read);
            }
            if (read == -1 || this.bufferClear == null || this.bufferClear.length == 0) {
                try {
                    this.bufferClear = this.cipher.doFinal();
                }
                catch (IllegalBlockSizeException e) {
                    this.bufferClear = null;
                }
                catch (BadPaddingException e) {
                    this.bufferClear = null;
                }
            }
            if (this.bufferClear == null || this.bufferClear.length == 0) {
                return -1;
            }
            this.maxIndex = this.bufferClear.length - 1;
        }
        return this.bufferClear[this.index++] & 0xFF;
    }

    private byte[] readSalt() throws IOException {
        byte[] headerBytes = new byte[OPENSSL_HEADER_STRING.length()];
        this.inStream.read(headerBytes);
        String headerString = new String(headerBytes, OPENSSL_HEADER_ENCODE);
        if (!OPENSSL_HEADER_STRING.equals(headerString)) {
            throw new IOException("unexpected file header " + headerString);
        }
        byte[] salt = new byte[8];
        this.inStream.read(salt);
        return salt;
    }

    private Cipher initializeCipher(char[] password, byte[] salt, int cipherMode, String algorithm, int iterationCount) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, NoSuchPaddingException, InvalidAlgorithmParameterException {
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(algorithm);
        SecretKey key = factory.generateSecret(keySpec);
        Cipher cipherInstance = Cipher.getInstance(algorithm);
        cipherInstance.init(cipherMode, (Key)key, new PBEParameterSpec(salt, iterationCount));
        return cipherInstance;
    }
}

