/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.screens;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.actions.Action;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.simple.Goto;
import ru.softlogic.input.model.field.FieldSequence;
import ru.softlogic.input.model.screen.Event;
import ru.softlogic.input.model.screen.EventRule;
import ru.softlogic.input.model.screen.description.ScreenDescription;
import ru.softlogic.parser.BaseElementParser;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ScenarioHelper;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.factory.BarcodeFactory;

public abstract class ScreenParser
extends BaseElementParser {
    public static final String DECOR_SEPARATOR = "/";

    protected abstract ScreenDescription _parse(Element var1) throws ParseException;

    public AdvancedScreenDescription parse(Element element, ParserContext context) throws ParseException {
        return this.createDefaultDescription(this._parse(element), element, context);
    }

    private AdvancedScreenDescription createDefaultDescription(ScreenDescription sd, Element element, ParserContext context) throws ParseException {
        String type = ScreenParser.getAttribute(element, "type").toLowerCase();
        sd.setType(type);
        sd.setId(ScreenParser.getAttribute(element, "id"));
        sd.setSubtitle(element.getAttribute("subtitle"));
        sd.setTitleId(ScreenParser.getAttribute(element, "title-id"));
        sd.setTitleAttr(ScreenParser.getAttribute(element, "title-attr"));
        sd.setDecor(element.getAttribute("decor"));
        sd.setTitle(ScreenParser.getAttribute(element, "title"));
        sd.setSound(ScreenParser.getAttribute(element, "sound"));
        int start = type.indexOf(DECOR_SEPARATOR) + 1;
        if (sd.getDecor().isEmpty() && start > 0) {
            int end = type.indexOf(DECOR_SEPARATOR, start);
            end = end < 0 ? type.length() : end;
            String decor = type.substring(start, end);
            sd.setDecor(decor);
        }
        sd.setBarcodeScanner(BarcodeFactory.createScanner(element));
        ActionMap am = ScenarioHelper.createActionMap(element, context);
        ActionMap navi = this.createNavigationMap(element, context);
        sd.setSequence(this.createFieldSequence(element));
        sd.setEventRules(this.getEventRules(element));
        return new AdvancedScreenDescription(sd, am, navi);
    }

    private List<EventRule> getEventRules(Element element) throws ParseException {
        Element eventsSection = ScreenParser.getElement(element, "events");
        ArrayList<EventRule> eventRules = null;
        if (eventsSection != null) {
            eventRules = new ArrayList<EventRule>();
            List<Element> events = ScreenParser.getElements(eventsSection, "event");
            for (Element event : events) {
                String type = ScreenParser.getAttribute(event, "type");
                String action = ScreenParser.getAttribute(event, "action");
                if (type == null || type.isEmpty() || action == null || action.isEmpty()) {
                    throw new ParseException("Event type or action is wrong: " + type + "," + action);
                }
                Event ev = null;
                if (!"CARD_STATE_INSIDE".equals(type)) {
                    throw new ParseException("Wrong event type: " + type);
                }
                ev = new Event(0);
                eventRules.add(new EventRule(ev, action));
            }
        }
        return eventRules;
    }

    private ActionMap createNavigationMap(Element element, ParserContext context) throws ParseException {
        List<Element> gotoElements;
        Action act;
        String title;
        String type;
        Element navigationSection = ScreenParser.getElement(element, "navigation");
        if (navigationSection == null) {
            return null;
        }
        ArrayList<Action> list = new ArrayList<Action>();
        List<Element> elements = ScreenParser.getElements(navigationSection, "action");
        if (!elements.isEmpty()) {
            Iterator<Element> iterator = elements.iterator();
            while (iterator.hasNext()) {
                Element el;
                Element action = el = iterator.next();
                type = ScreenParser.getAttribute(el, "type").toLowerCase();
                title = ScreenParser.getAttribute(el, "title").trim().replace("\\n", "\n");
                String titleId = ScreenParser.getAttribute(el, "title-id");
                boolean current = "true".equalsIgnoreCase(ScreenParser.getAttribute(el, "current"));
                act = new Action();
                act.setType(type);
                act.setTitle(title);
                act.setCurent(current);
                act.setTitleId(titleId);
                act.setSequence(ScenarioHelper.createActionSequence(action, context));
                list.add(act);
            }
        }
        if (!(gotoElements = ScreenParser.getElements(navigationSection, "goto-action")).isEmpty()) {
            for (Element el : gotoElements) {
                type = ScreenParser.getAttribute(el, "type").toLowerCase();
                title = ScreenParser.getAttribute(el, "title");
                String target = ScreenParser.getAttribute(el, "target");
                String titleId = ScreenParser.getAttribute(el, "title-id");
                act = new Action(type, title, titleId);
                ArrayList<Goto> result = new ArrayList<Goto>();
                result.add(new Goto(target));
                act.setSequence(result);
                list.add(act);
            }
        }
        return list.isEmpty() ? null : new ActionMap(list);
    }

    protected FieldSequence createFieldSequence(Element element) throws ParseException {
        Element fieldsSection = ScreenParser.getElement(element, "fields");
        if (fieldsSection == null) {
            return null;
        }
        return new FieldSequence(ScenarioHelper.getFieldList(fieldsSection));
    }
}

