/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.fields;

import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Modificator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.input.model.field.text.VoidFilter;
import ru.softlogic.input.model.field.text.VoidModificator;
import ru.softlogic.parser.FieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.v2.ScenarioParserW3C;
import ru.softlogic.parser.adv.v2.fields.FieldParser;
import ru.softlogic.parser.factory.KeyboardFactory;
import ru.softlogic.parser.factory.filter.FilterFactory;
import ru.softlogic.parser.factory.formatter.FormatterFactory;
import ru.softlogic.parser.factory.modificator.ModificatorFactory;
import ru.softlogic.parser.factory.validator.ValidatorCreatingException;
import ru.softlogic.parser.factory.validator.ValidatorFactory;

@FieldAnnotation(name="text-field")
public class TextField
extends FieldParser {
    @Override
    public List<? extends IdentityField> parse(Element field) throws ParseException {
        ru.softlogic.input.model.field.text.TextField tf = new ru.softlogic.input.model.field.text.TextField();
        this.prefillField((IdentityField)tf, field);
        tf.setFlags(this.getFlags(field));
        tf.setDefaultValue(TextField.getAttribute(field, "default"));
        tf.setExampleValue(TextField.getAttribute(field, "example"));
        tf.setErrorMessage(this.getErrorMessage(field));
        tf.setPrefix(TextField.getAttribute(field, "prefix"));
        tf.setPostfix(TextField.getAttribute(field, "postfix"));
        tf.setMaxLength(this.getMaxLen(field, tf.getId(), ScenarioParserW3C.getParams()));
        tf.setKeyboard(KeyboardFactory.createAdv(field));
        tf.setSecure(Boolean.parseBoolean(TextField.getAttribute(field, "secure")));
        tf.setReadOnly(Boolean.parseBoolean(TextField.getAttribute(field, "read-only")));
        tf.setFailRegex(TextField.getAttribute(field, "fail-regex"));
        tf.setExist(this.getExist(field));
        tf.setFilter((Filter)new VoidFilter());
        Element fmtEl = TextField.getElement(field, "formatter");
        Element filterEl = TextField.getElement(field, "filter");
        Element dataFmtEl = TextField.getElement(field, "data-formatter");
        tf.setValidator(this.getValidator(field, tf.getId()));
        Element modifSection = TextField.getElement(field, "modificator");
        Modificator modificator = ModificatorFactory.createAdv(modifSection);
        if (modificator != null) {
            tf.setModificator(modificator);
        } else {
            tf.setModificator((Modificator)new VoidModificator());
        }
        if (fmtEl != null) {
            tf.setFormatter(FormatterFactory.createAdv(fmtEl));
        }
        if (filterEl != null) {
            tf.setFilter(FilterFactory.createAdv(filterEl));
        }
        if (dataFmtEl != null) {
            tf.setDataFormatter(FormatterFactory.createAdv(dataFmtEl));
        }
        return Collections.singletonList(tf);
    }

    private Validator getValidator(Element element, String name) throws ParseException {
        try {
            Element verify = TextField.getElement(element, "validator");
            Validator validator = ValidatorFactory.createAdv(verify);
            return this.checkValidator(validator, name, ScenarioParserW3C.getParams());
        }
        catch (ValidatorCreatingException ex) {
            throw new ParseException(ex);
        }
    }
}

